Epoch: 1
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		    flexdock
Version:        1.2.4
Release:	    alt1_14jpp11
Summary:	    Docking framework for Java Swing GUI apps


#Licence is MIT on their website
License:	    MIT 
URL:		    http://forge.scilab.org/index.php/p/flexdock/

Source0:	    http://forge.scilab.org/index.php/p/flexdock/downloads/get/%{name}-%{version}.tar.gz

#Removes the java media framework from the demos to satisfy reqs
Patch1:		    flexdock-0001-nojmf.patch
#Modifies the build process  -- fedora specific
Patch2:		    flexdock-0002-fedora-build.patch
#Set javac source and target version to 1.8 to fix builds with Java 11
Patch3:         flexdock-0003-java-1.8.patch

BuildRequires:	ant
BuildRequires:	jpackage-utils
BuildRequires:	jgoodies-common
BuildRequires:	jgoodies-looks
BuildRequires:	skinlf

Requires:       java
Requires:       jpackage-utils
Requires:       jgoodies-common
Requires:       jgoodies-looks
Requires:       skinlf

BuildArch:      noarch
Source44: import.info

%description
FlexDock is a Java docking framework for use in cross-platform
Swing applications.

%prep
%setup -q

%patch1 -p1
%patch2 -p1
%patch3 -p1

#Override the build file's default hard-coded paths
echo "sdk.home=%{java_home}" > workingcopy.properties

#JAR "dependency" handling
find ./ -name \*.jar -exec rm {} \;
build-jar-repository -s -p lib skinlf jgoodies-looks jgoodies-common

#Remove the jmf-using demo files
rm src/java/demo/org/flexdock/demos/raw/jmf/MediaPanel.java
rm src/java/demo/org/flexdock/demos/raw/jmf/JMFDemo.java

#Endline convert Doc files
for i in "LICENSE.txt README release-notes.txt" ;
do
    sed -i 's/\r//' $i
done

%build
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  jar

%install
mkdir -p %{buildroot}%{_javadir}
install -pm644 build/%{name}-%{version}.jar %{buildroot}%{_javadir}/%{name}.jar

%files
%doc LICENSE.txt README release-notes.txt
%{_javadir}/*

%changelog
