Name: fritzing
Version: 0.9.6
Release: alt1

Summary: Intuitive EDA platform featuring from prototype to product
License: GPLv3, CC-BY-SA-3.0
Group: Engineering

Url: http://fritzing.org
# https://github.com/fritzing/fritzing-app
Source0: %name-%version.tar
# https://github.com/fritzing/fritzing-parts
Source1: %name-parts.tar
# Need to refresh at every update of fritzing-parts
# Execute Fritzing -db parts.db in fritzing-parts directory
# 1. Install new version of Fritzing and parts
# 2. cd /usr/share/fritzing/fritzing-parts/core
# 3. git init . ; git add . ; git commit
# 4. Fritzing . -db ~/parts.db
# 5. ???
# 6. PROFIT!!!
Source2: parts.db

Patch: fritzing-desktop-file-translation.patch

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires: boost-devel-headers desktop-file-utils gcc-c++ glibc-devel-static
BuildRequires: rpm-build-python3 rpmbuild-helper-desktop zlib-devel
BuildRequires: rpmbuild-helper-sugar-activity ruby ruby-stdlibs qt5-tools
BuildRequires: libgit2-devel qt5-base-devel qt5-svg-devel qt5-serialport-devel

# large chunk of arch-independent data is better not duplicated
Requires: %name-data = %EVR

%description
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

%package data
Summary: Data files for %name
License: GPLv3
Group: Engineering
BuildArch: noarch

%description data
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

This package contains shared data files for Fritzing.

%prep
%setup -a1

# Dynamically link against system libgit2
sed -i 's/LIBGIT_STATIC = true/LIBGIT_STATIC = false/' phoenix.pro

%patch -p1

# make sure that russian translation will be removed
rm translations/fritzing_ru.qm

# rebuild russian translation
lrelease-qt5 phoenix.pro

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
qmake-qt5
%make_build debug

%install
%makeinstall_std INSTALL_ROOT=%buildroot debug-install

cp -r %name-parts %buildroot/%_datadir/%name

install -m0644 %SOURCE2 "%buildroot/%_datadir/%name/%name-parts/parts.db"

%files
%doc LICENSE.*
%_bindir/Fritzing
%_pixmapsdir/%name.png
%_desktopdir/org.fritzing.Fritzing.desktop
%_datadir/metainfo/org.fritzing.Fritzing.appdata.xml
%_man1dir/Fritzing.*
%_datadir/mime/packages/%name.xml
%_datadir/metainfo

%files data
%_datadir/%name

%changelog
