%set_autoconf_version 2.60
%define marker custom
%define gcc_custom_libdir %_libdir/%marker-gcc

%define gcc_branch 13

Name: gcc%gcc_branch
Version: 13.2.1
Release: alt2.p10.1

Summary: GNU Compiler Collection
# libgcc, libgomp, libstdc++ and crtstuff have
# GCC Runtime Exception.
License: LGPL-2.1-or-later and LGPL-3.0-or-later and GPL-2.0-or-later and GPL-3.0-or-later and GPL-3.0-or-later with GCC-exception-3.1

Group: Development/C
Url: https://gcc.gnu.org/

%ifarch ppc
# On ppc32, we build a 64-bit compiler with default 32-bit mode.
%define _target_platform ppc64-alt-linux
%endif

%define snapshot 20240128

%define srcver %version-%snapshot-%release
%define srcfilename gcc-%srcver
%define srcdirname gcc-%srcver
%define psuffix -%gcc_branch
%define _libexecdir /usr/libexec

%define gcc_target_libdir %_libdir/gcc/%_target_platform/%gcc_branch
%define gcc_target_libexecdir %_libexecdir/gcc/%_target_platform/%gcc_branch
%define gcc_target_platform %_target_platform

%define gcc_gdb_auto_load %_datadir/gdb/auto-load%_libdir/
%define gcc_doc_dir %_docdir/gcc%psuffix
# due to -z relro by default
%define binutils_deps binutils >= 1:2.24.0

%define gcc_sourcedir /usr/src/gcc-source

%ifarch x86_64
%define compat_platform i586-alt-linux
%define gcc_target_lib32dir /usr/lib/gcc/%compat_platform/%gcc_branch
%define gxx32idir %_includedir/c++/%gcc_branch/%compat_platform
%define gxx64idir %_includedir/c++/%gcc_branch/%_target_platform
%endif

%define libasan_arches		%ix86 x86_64 %arm aarch64 ppc64le mipsel riscv64 loongarch64
%define libhwasan_arches	x86_64 aarch64
%define libatomic_arches	%ix86 x86_64 %arm aarch64 mips mipsel s390x riscv64 ppc64le loongarch64
%define libitm_arches		%ix86 x86_64 %arm aarch64 s390x ppc64le riscv64 loongarch64
%define liblsan_arches		x86_64 aarch64 ppc64le
%define libquadmath_arches	%ix86 x86_64 ppc64le
%define libtsan_arches		x86_64 aarch64 ppc64le
%define libubsan_arches		%ix86 x86_64 %arm aarch64 ppc64le riscv64 loongarch64
%define libvtv_arches		%ix86 x86_64

# gccrs can't compile the standard libraries yet and requires annoying
# -frust-incomplete-and-experimental-compiler-do-not-use option to compile
# anything.
# See https://gcc.gnu.org/git/?p=gcc.git;a=commit;f=configure.ac;h=54a1630b4abadb8f4b207ebf4baf5c8a6b5adb9a
%def_disable rust
%ifarch %libasan_arches
%def_with libsanitizer
%endif
%ifarch %libhwasan_arches
%def_with libsanitizer
%endif
%ifarch %libtsan_arches
%def_with libsanitizer
%endif
%ifarch %libubsan_arches
%def_with libsanitizer
%endif
%ifarch %liblsan_arches
%def_with libsanitizer
%endif

%ifarch %libvtv_arches
# We desided to allow libvtv to use "__fortify_fail@GLIBC_PRIVATE".
%filter_from_requires /^libc.so.6(GLIBC_PRIVATE)/d
%endif

%set_compress_method xz
%ifarch %arm
%set_verify_elf_method textrel=relaxed
%endif

# Build parameters.
%def_enable bootstrap
# When we want to update gcc, we have to:
# 0. build gcc N in precompat mode;
# 1. build gcc N+1 with gcc N;
# 2. build gcc N in compat mode.
# Unfortunately, if we skip stage 0 at stage 2, installation of gcc N
# would be broken because it has strict requirements on libgcc1 package,
# but hasher installs libgcc1 from gcc N+1 early.
# precompat knob disables interpackage dependencies optimization
# and changes interpackage dependencies to non-strict (>=);
# this gcc is expected to be installable at stage 2.
# NB: compat and precompat are mutually exclusive.
%def_enable precompat
%def_disable compat

# For some architectures we do not want multilib support.
%ifarch riscv64 loongarch64
%def_disable multilib
%else
%def_enable multilib
%endif
%ifnarch ppc ppc64
%def_with objc
%endif
%def_disable objc_gc

%if_disabled compat
%def_enable source
%def_with jit
%endif

%if 0%{?_enable_compat:1}%{?_enable_precompat:1}
%define REQ >=
%else
%define REQ =
%endif

%def_without pdf
%def_disable doxygen
%def_disable check

%define buildtarget obj-%gcc_target_platform

Source: %srcfilename.tar

%define gcc_description \
This package contains the GNU Compiler Collection version %version.\
You'll need this package in order to compile C code.\
It is also required for all other GCC compilers.\
\
If you have multiple versions of the GNU Compiler Collection\
installed on your system, you may want to execute\
gcc%psuffix\
in order to explicitly use the GNU C compiler version %version.

%description
%gcc_description

####################################################################
# GCC Compiler

%package -n %marker-%name
Summary: GNU Compiler Collection
Group: Development/C

Conflicts: glibc-devel < 2.2.6
Requires(pre): gcc-common >= 1.4.7
Requires: %marker-cpp%gcc_branch = %EVR
Requires: %binutils_deps, glibc-devel
Requires: %marker-libgcc1 %REQ %EVR
%ifarch %libatomic_arches
Requires: %marker-libatomic1 %REQ %EVR
%endif
%ifarch %libasan_arches
Requires: %marker-libasan8 %REQ %EVR
%endif
%ifarch %libitm_arches
Requires: %marker-libitm1 %REQ %EVR
%endif
%ifarch %libtsan_arches
Requires: %marker-libtsan2 %REQ %EVR
%endif
BuildPreReq: rpm-build >= 4.0.4-alt39, %binutils_deps
BuildPreReq: gcc-c++ coreutils flex makeinfo
BuildPreReq: libelf-devel libmpc-devel libmpfr-devel
# due to manpages
BuildPreReq: perl-Pod-Parser
BuildPreReq: zlib-devel libzstd-devel

%{?_with_objc:%{?_enable_objc_gc:BuildPreReq: libgc-devel}}
%{?_enable_doxygen:BuildPreReq: doxygen graphviz tetex-latex}
%{?_with_pdf:BuildPreReq: tetex-dvips}
%{?!_without_check:%{?!_disable_check:BuildRequires: autogen, dejagnu, glibc-devel-static, /proc, /dev/pts}}

%description -n %marker-%name
%gcc_description

####################################################################
# GCC plugin

%package -n %marker-%name-plugin-devel
Summary: GCC Plugin header files
Group: Development/Other
Requires: %marker-%name = %EVR
Requires: libgmp-devel

%description -n %marker-%name-plugin-devel
This package contains header files required to build GCC plugins.

####################################################################
# GCC library

%package -n %marker-libgcc1
Summary: GCC shared support library
Group: System/Libraries
Requires(pre): glibc-core

%description -n %marker-libgcc1
This package contains GCC shared support library which is needed
e.g. for exception handling support.

####################################################################
# Atomic library

%package -n %marker-libatomic1
Summary: The GNU Atomic library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libatomic1
This package contains the GNU Atomic library which is a GCC support
runtime library for atomic operations not supported by hardware.

%package -n %marker-libatomic%gcc_branch-devel-static
Summary: The GNU Atomic static library
Group: Development/C
Requires: %marker-libatomic1 %REQ %EVR

%description -n %marker-libatomic%gcc_branch-devel-static
This package contains GNU Atomic static library.

####################################################################
# Address Sanitizer library

%package -n %marker-libasan8
Summary: The Address Sanitizer runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libasan8
This package contains the Address Sanitizer runtime library
which is used for -fsanitize=address instrumented programs.

%package -n %marker-libasan%gcc_branch-devel-static
Summary: The Address Sanitizer static library
Group: Development/C
Requires: %marker-libasan8 %REQ %EVR

%description -n %marker-libasan%gcc_branch-devel-static
This package contains Address Sanitizer static library.

####################################################################
# Hardware-assisted Address Sanitizer library

%package -n %marker-libhwasan0
Summary: The Hardware-assisted Address Sanitizer runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libhwasan0
This package contains the Hardware-assisted Address Sanitizer runtime
library which is used for -fsanitize=hwaddress instrumented programs.

%package -n %marker-libhwasan%gcc_branch-devel-static
Summary: The Hardware-assisted Address Sanitizer static library
Group: Development/C
Requires: %marker-libhwasan0 %REQ %EVR

%description -n %marker-libhwasan%gcc_branch-devel-static
This package contains Hardware-assisted Address Sanitizer static library.

####################################################################
# Thread Sanitizer library

%package -n %marker-libtsan2
Summary: The Thread Sanitizer runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libtsan2
This package contains the Thread Sanitizer runtime library
which is used for -fsanitize=thread instrumented programs.

%package -n %marker-libtsan%gcc_branch-devel-static
Summary: The Thread Sanitizer static library
Group: Development/C
Requires: %marker-libtsan2 %REQ %EVR

%description -n %marker-libtsan%gcc_branch-devel-static
This package contains Thread Sanitizer static library.

####################################################################
# ITM library

%package -n %marker-libitm1
Summary: The GNU Transactional Memory library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libitm1
This package contains the GNU Transactional Memory library
which is a GCC transactional memory support runtime library.

%package -n %marker-libitm%gcc_branch-devel-static
Summary: The GNU Transactional Memory static library
Group: Development/C
Requires: %marker-libitm1 %REQ %EVR

%description -n %marker-libitm%gcc_branch-devel-static
This package contains GNU Transactional Memory static libraries.

####################################################################
# OpenMP library

%package -n %marker-libgomp1
Summary: GCC OpenMP shared support library
Group: System/Libraries

%description -n %marker-libgomp1
This package contains GCC OpenMP shared support library.

%package -n %marker-libgomp%gcc_branch-devel
Summary: GCC OpenMP support files
Group: Development/Other
Requires: %marker-libgomp1 %REQ %EVR
Requires: glibc-devel

%description -n %marker-libgomp%gcc_branch-devel
This package contains GCC OpenMP headers and library.

%package -n %marker-libgomp%gcc_branch-devel-static
Summary: GCC OpenMP static support library
Group: Development/Other
Requires: %marker-libgomp%gcc_branch-devel = %EVR

%description -n %marker-libgomp%gcc_branch-devel-static
This package contains GCC OpenMP static library.

####################################################################
# GCC plugin for GDB
%package -n %marker-%name-gdb-plugin
Summary: GCC plugin for GDB
Group: Development/Debuggers
Requires: %marker-gcc%gcc_branch = %EVR
Provides: %marker-%name-gdb-plugin-devel = %EVR
Obsoletes: %marker-%name-gdb-plugin-devel < %EVR

%description -n %marker-%name-gdb-plugin
This package contains GCC plugin for GDB C expression evaluation.

####################################################################
# GCC JIT Library
%package -n %marker-libgccjit0
Summary: Library for embedding GCC inside programs and libraries
Group: System/Libraries

%description -n %marker-libgccjit0
This package contains shared library with GCC JIT front-end.

%package -n %marker-libgccjit%gcc_branch-devel
Summary: Support for embedding GCC inside programs and libraries
Group: Development/C
Requires: %marker-libgccjit0 = %EVR

%description -n %marker-libgccjit%gcc_branch-devel
This package contains header files for GCC JIT front-end.

####################################################################
# quadmath library
%package -n %marker-libquadmath0
Summary: GCC __float128 shared support library
Group: System/Libraries

%description -n %marker-libquadmath0
This package contains GCC shared support library which is needed
for __float128 math support and for Fortran REAL*16 support.

%package -n %marker-libquadmath%gcc_branch-devel
Summary: GCC __float128 support files
Group: Development/Other
Requires: %marker-libquadmath0 %REQ %EVR

%description -n %marker-libquadmath%gcc_branch-devel
This package contains headers for building Fortran programs using
REAL*16 and programs using __float128 math.

%package -n %marker-libquadmath%gcc_branch-devel-static
Summary: GCC __float128 static support library
Group: Development/Other
Requires: %marker-libquadmath%gcc_branch-devel = %EVR

%description -n %marker-libquadmath%gcc_branch-devel-static
This package contains static libraries for building Fortran programs
using REAL*16 and programs using __float128 math.

####################################################################
# Leak Sanitizer library

%package -n %marker-liblsan0
Summary: The Leak Sanitizer runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-liblsan0
This package contains the Leak Sanitizer library
which is used for -fsanitize=leak instrumented programs.

%package -n %marker-liblsan%gcc_branch-devel-static
Summary: The Leak Sanitizer static library
Group: Development/C
Requires: %marker-liblsan0 %REQ %EVR

%description -n %marker-liblsan%gcc_branch-devel-static
This package contains Leak Sanitizer static runtime library.

####################################################################
# Undefined Behavior Sanitizer library

%package -n %marker-libubsan1
Summary: The Undefined Behavior Sanitizer runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libubsan1
This package contains the Undefined Behavior Sanitizer library
which is used for -fsanitize=undefined instrumented programs.

%package -n %marker-libubsan%gcc_branch-devel-static
Summary: The Undefined Behavior Sanitizer static library
Group: Development/C
Requires: %marker-libubsan1 %REQ %EVR

%description -n %marker-libubsan%gcc_branch-devel-static
This package contains Undefined Behavior Sanitizer static runtime library.

####################################################################
# VTable Verification library

%package -n %marker-libvtv0
Summary: The VTable Verification library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libvtv0
This package contains the GNU Transactional Memory library
which is a GCC transactional memory support runtime library.

%package -n %marker-libvtv%gcc_branch-devel-static
Summary: The GNU Transactional Memory static library
Group: Development/C
Requires: %marker-libvtv0 %REQ %EVR

%description -n %marker-libvtv%gcc_branch-devel-static
This package contains GNU Transactional Memory static libraries.

####################################################################
# Preprocessor

%package -n %marker-cpp%gcc_branch
Summary: The GNU C-Compatible Compiler Preprocessor
Group: Development/C
Obsoletes: gcc-cpp egcs-cpp cpp3.0 cpp3.1
Requires(pre): gcc-common >= 1.4.7

%description -n %marker-cpp%gcc_branch
Cpp is the GNU C-Compatible Compiler Preprocessor.
The C preprocessor is a 'macro processor' which is used automatically
by the C compiler to transform your program before actual
compilation. It is called a macro processor because it allows
you to define 'macros,' which are abbreviations for longer
constructs.

The C preprocessor provides four separate facilities that you can use as
you see fit:

* Inclusion of header files. These are files of declarations that can be
  substituted into your program.
* Macro expansion. You can define 'macros,' which are abbreviations for
  arbitrary fragments of C code, and then the C preprocessor will replace
  the macros with their definitions throughout the program.
* Conditional compilation. Using special preprocessing directives,
  you can include or exclude parts of the program according to various
  conditions.
* Line control. If you use a program to combine or rearrange source files
  into an intermediate file which is then compiled, you can use line
  control to inform the compiler about where each source line originated.

If you have multiple versions of the GNU Compiler Collection
installed on your system, you may want to execute
cpp%psuffix
in order to explicitly use the GNU C Preprocessor version %version.

####################################################################
# C++ Libraries

%package -n %marker-libstdc++6
Summary: GNU Standard C++ library
Group: System/Libraries
AutoReq: yes, nopython
Requires: %marker-libgcc1 %REQ %EVR
# due to TLS (#9732)
Requires(pre): glibc-core >= 6:2.3.6-alt7

%description -n %marker-libstdc++6
This package contains a rewritten standard compliant GCC Standard C++
Library.

%package -n %marker-libstdc++%gcc_branch-devel
Summary: Header files and libraries for C++ development
Group: Development/C++
Requires(pre): gcc-c++-common >= 1.4.7
Requires: %marker-libstdc++6 %REQ %EVR
Requires: glibc-devel

%description -n %marker-libstdc++%gcc_branch-devel
This is the GNU implementation of the standard C++ libraries.
This package includes the header files and libraries needed for C++
development.  This includes rewritten implementation of STL.

%package -n %marker-libstdc++%gcc_branch-devel-static
Summary: Static libraries for C++ development
Group: Development/C++
Requires(pre): gcc-c++-common >= 1.4.7
Requires: %marker-libstdc++%gcc_branch-devel = %EVR

%description -n %marker-libstdc++%gcc_branch-devel-static
This is the GNU implementation of the standard C++ libraries.
This package includes static library needed for C++ development.

####################################################################
# C++ Compiler

%package -n %marker-%name-c++
Summary: C++ support for gcc
Group: Development/C++
Requires(pre): gcc-c++-common >= 1.4.7
Requires: %marker-%name = %EVR
Requires: %marker-libstdc++%gcc_branch-devel = %EVR

%description -n %marker-%name-c++
This package adds C++ support to the GNU Compiler Collection.
It includes support for most of the current C++ specification,
including templates and exception handling.

If you have multiple versions of the GNU Compiler Collection
installed on your system, you may want to execute
g++%psuffix
in order to explicitly use the GNU C++ compiler version %version.

####################################################################
# D Runtime

%package -n %marker-libgdruntime4
Summary: D runtime
Group: System/Libraries

%description -n %marker-libgdruntime4
This package contains DRuntime shared library which is the
low-level runtime library backing the D programming language.

%package -n %marker-libgdruntime%gcc_branch-devel
Summary: Development files for DRuntime library
Group: Development/Other
Requires: %marker-libgdruntime4 = %EVR

%description -n %marker-libgdruntime%gcc_branch-devel
This package contains development files for DRuntime library.

%package -n %marker-libgdruntime%gcc_branch-devel-static
Summary: Static DRuntime library
Group: Development/Other
Requires: %marker-libgdruntime4 = %EVR
Requires: %marker-libgdruntime%gcc_branch-devel = %EVR

%description -n %marker-libgdruntime%gcc_branch-devel-static
This package contains static DRuntime library.

%package -n %marker-libgphobos4
Summary: D runtime
Group: System/Libraries

%description -n %marker-libgphobos4
This packages contains the standard library for the D Programming
Language which is needed to run D dynamically linked programs.

%package -n %marker-libgphobos%gcc_branch-devel
Summary: Development files for DRuntime library
Group: Development/Other
Requires: %marker-libgphobos4 = %EVR

%description -n %marker-libgphobos%gcc_branch-devel
This package contains development files for DRuntime library.

%package -n %marker-libgphobos%gcc_branch-devel-static
Summary: Static D libraries
Group: Development/Other
Requires: %marker-libgphobos%gcc_branch-devel = %EVR

%description -n %marker-libgphobos%gcc_branch-devel-static
This package contains static D standard library.

####################################################################
# Objective-C Libraries

%package -n %marker-libobjc4
Summary: Objective-C runtime library
Group: System/Libraries
Requires: %marker-libgcc1 %REQ %EVR

%description -n %marker-libobjc4
This package contains Objective-C shared library which is needed to run
Objective-C dynamically linked programs.

%package -n %marker-libobjc%gcc_branch-devel
Summary: Header files and library for Objective-C development
Group: Development/Other
Requires(pre): gcc-common >= 1.4.7
Requires: %marker-libobjc4 %REQ %EVR
Requires: glibc-devel

%description -n %marker-libobjc%gcc_branch-devel
This is the GNU implementation of the standard Objective-C libraries.
This package includes the header files and library needed for
Objective-C development.

%package -n %marker-libobjc%gcc_branch-devel-static
Summary: Static libraries for Objective-C development
Group: Development/Other
Requires(pre): gcc-common >= 1.4.7
Requires: %marker-libobjc%gcc_branch-devel = %EVR

%description -n %marker-libobjc%gcc_branch-devel-static
This is the GNU implementation of the standard Objective-C libraries.
This package includes the static library needed for Objective-C
development.

####################################################################
# Objective-C Compiler

%package -n %marker-%name-objc
Summary: Objective-C support for GCC
Group: Development/Other
Requires(pre): gcc-common >= 1.4.7
Requires: %marker-%name = %EVR
Requires: %marker-libobjc%gcc_branch-devel = %EVR

%description -n %marker-%name-objc
This package provides Objective-C support for the GCC.
Mainly used on systems running NeXTSTEP, Objective-C is an
object-oriented derivative of the C language.

%package -n %marker-%name-objc++
Summary: Objective-C++ support for GCC
Group: Development/Other
Requires(pre): gcc-common >= 1.4.7
Requires: %marker-%name-objc = %EVR, %marker-%name-c++ = %EVR

%description -n %marker-%name-objc++
This package provides Objective-C++ support for the GCC.

####################################################################
# GCC sources
%package -n %marker-%name-source
Summary: GCC sources
Group: Development/Other
BuildArch: noarch

%description -n %marker-%name-source
This package contains source code of GNU Compiler Collection version %version.

####################################################################
# GCC localization
%package -n %marker-%name-locales
Summary: The GNU Compiler Collection native language support files
Group: Development/C
BuildArch: noarch
Requires: %marker-%name = %EVR

%description -n %marker-%name-locales
This packages contains files required for native language support for
the GNU Compiler Collection.

####################################################################
# GCC documentation

%package -n %marker-%name-doc
Summary: GCC documentation
Group: Development/Other
BuildArch: noarch

%description -n %marker-%name-doc
This package contains documentation for the GNU Compiler Collection
version %version.

%prep
%setup -n %srcdirname

subst 's/HAVE_FPRINTF_UNLOCKED/NEVER_&/' {fixincludes,libcpp,gcc}/system.h 

echo '%distribution %version-%release' > gcc/DEV-PHASE

# due to autoconf >= 2.69
# TODO: no go! but absence of this workaround fails overall reconfiguration
> libgo/config/go.m4

# This test causes fork failures, because it spawns way too many threads
rm -f gcc/testsuite/go.test/test/chan/goroutines.go

# Remove -I- gcc option.
find -type f -name Makefile\* -print0 |
	xargs -r0 grep -F -Zle '-I- ' -- |
	xargs -r0 sed -i 's/-I- //g' --

# Disable unwanted multilib builds.
%ifarch x86_64 mips mipsel mips64 mips64el riscv64 ppc64le
sed -i 's/\$(CC_FOR_TARGET) --print-multi-lib/echo '"'.;'/" Makefile.*
sed -i 's/\${CC-gcc} --print-multi-lib/echo '"'.;'/" config-ml.in
sed -i 's/\[ -z "\$(MULTIDIRS)" \]/true/' config-ml.in
%endif

find -type f -name \*.orig -delete -print

# Automake >= 1.10 behaviour changed.
#find -name Makefile.am -print0 |
#	xargs -r0 grep -F -lZ '_LINK = ' -- |
#	xargs -r0 sed -i '/_LDFLAGS)/! s/^\([^ ]\+\)_LINK = \$([^ ]\+)/& \$(\1_LDFLAGS)/' --

# Misdesign in libstdc++.
cp -a libstdc++-v3/config/cpu/i{4,3}86/atomicity.h

# Remove harmful autotools redeclarations.
>config/override.m4

# Replace m4_rename with m4_rename_force to fix build with autoconf >= 2.64.
if grep -F -wqs m4_rename_force /usr/share/autoconf/m4sugar/m4sugar.m4; then
	find -type f -name configure.ac -print0 |
		xargs -r0 grep -F -wlZ 'm4_rename' |
		xargs -r0 sed -i 's/\<m4_rename\>/&_force/' --
fi

# Adjust libstdc++ docs and its doxygen config.
%define onlinedocs http://gcc.gnu.org/onlinedocs
find libstdc++-v3/doc/ -type f -print0 |
	xargs -r0 grep -FZl libstdc++-html-USERS -- |
	xargs -r0 sed -i 's|libstdc++-html-USERS|%onlinedocs/libstdc++/&|' --
find libstdc++-v3/doc/ -type f -print0 |
	xargs -r0 grep -FZl '"latest-doxygen/' -- |
	xargs -r0 sed -i 's|"latest-doxygen/|"%onlinedocs/libstdc++/latest-doxygen/|' --
sed -i "s|\\(^INCLUDE_PATH[[:space:]]\\+=\\)[[:space:]]*$|\\1 $PWD/%buildtarget/%_target_platform/libstdc++-v3/include|" \
	libstdc++-v3/doc/doxygen/user.cfg.in

%build
libtoolize --copy --install --force
install -pm644 %_datadir/libtool/aclocal/*.m4 .

%autoreconf

# Regenerate configure scripts.
for f in */aclocal.m4; do
	d="${f%%/*}"
	grep ^m4_include "$d"/aclocal.m4 |
		grep -E -v '\[(libltdl/)?acinclude\.m4\]' >acinclude.m4~ ||:
	touch "$d"/acinclude.m4
	cat "$d"/acinclude.m4 >>acinclude.m4~
	mv acinclude.m4~ "$d"/acinclude.m4
	%autoreconf "$d"
	sh -n "$d"/configure
done

# Libtoolize now removes those of its build-aux files
# that haven't been installed during its invocation.
# Invoke libtoolize once more to install missing files.
# gotools is just one of those directories that could
# be used to install all necessary build-aux files.
%autoreconf gotools

./contrib/gcc_update --touch

rm -rf %buildtarget
mkdir %buildtarget
pushd %buildtarget

%if_with ada
rm -rf ada_hacks
for n in gnat %ada_binaries; do
	if [ -f "%_bindir/$n" ]; then
		continue
	fi
	if [ ! -f "%_bindir/$n%psuffix" ]; then
		echo "%_bindir/$n not found!" >&2
		exit 1
	fi
	mkdir -p ada_hacks
	ln -s "%_bindir/$n%psuffix" ada_hacks/"$n"
done
if [ -d ada_hacks ]; then
	export PATH="$PWD/ada_hacks${PATH:+:"$PATH"}"
fi
%endif

%define _configure_script ../configure
%define _configure_target --host=%_target_platform --build=%_target_platform --target=%gcc_target_platform
# Remove lto flags, these flags break GCC build, but GCC supports
# special bootstrap-lto build config.
%global optflags_lto %nil
%remove_optflags -frecord-gcc-switches %optflags_nocpp %optflags_notraceback %optflags_warnings
export CC=%__cc \
	CFLAGS="%optflags" \
	CXXFLAGS="%optflags" \
	FFLAGS="%optflags" \
	GCJFLAGS="%optflags" \
	TCFLAGS="%optflags" \
	XCFLAGS="%optflags" \
	ac_cv_file__proc_self_exe=yes \
	gcc_cv_libc_provides_ssp=yes \
	libffi_cv_ro_eh_frame=yes \
	#

CONFIGURE_OPTS="\
	--enable-shared \
	--program-suffix=%psuffix \
	--with-slibdir=/%_lib \
	--libexecdir=%_libdir \
	--with-bugurl=http://bugzilla.altlinux.org \
	--enable-__cxa_atexit \
	--enable-threads=posix \
	--enable-checking=release \
	--with-system-zlib \
	--with-zstd \
	--without-included-gettext \
	%{subst_enable multilib} \
	--enable-default-pie \
	--enable-gnu-unique-object \
	--enable-linker-build-id \
%ifnarch mips mips64 mipsel mips64el
	--with-linker-hash-style=gnu \
%endif
%ifarch %ix86
	--with-arch=%_target_cpu --with-tune=generic \
%endif
%ifarch x86_64
	--with-arch_32=i586 --with-tune_32=generic \
	--with-multilib-list=m64,m32,mx32 \
%endif
%ifarch ppc ppc64 ppc64le
	--enable-secureplt \
	--with-long-double-128 \
%endif
%ifarch ppc ppc64
	--disable-softfloat \
%endif
%ifarch ppc64le
	--enable-targets=powerpcle-linux \
	--with-cpu-32=power8 --with-tune-32=power8 \
	--with-cpu-64=power8 --with-tune-64=power8 \
%endif
%ifarch ppc
	--with-cpu=default32 \
%endif
%ifarch armh
	--with-tune=cortex-a8 --with-arch=armv7-a \
	--with-float=hard --with-fpu=vfpv3-d16 --with-abi=aapcs-linux \
	--disable-sjlj-exceptions \
%endif
%ifarch arm
	--with-arch=armv5te --with-float=soft --with-abi=aapcs-linux \
	--disable-sjlj-exceptions \
%endif
%ifarch mips mipsel mips64 mips64el
	--enable-targets=all \
	--with-arch-32=mips32r2 --with-fp-32=xx \
	--with-arch-64=mips64r2 \
%endif
%ifarch mips64 mips64el
	--with-mips-plt \
%endif
%ifarch mips mipsel
	--with-lxc1-sxc1=no \
%endif
%ifarch mipsel mips64el \
	--with-madd4=no \
%endif
%ifarch riscv64
	--with-arch=rv64gc --with-abi=lp64d \
%endif
	"

%configure \
	$CONFIGURE_OPTS \
	--with-gcc-major-version-only \
%ifarch %libvtv_arches
	--enable-vtable-verify \
%endif
%if_enabled bootstrap
	--enable-bootstrap \
	--with-build-config=bootstrap-lto \
	--enable-link-serialization=1 \
%endif
	--enable-languages="c,c++%{?_with_objc:,objc,obj-c++},lto" \
	--enable-plugin \
	%{?_with_objc:%{?_enable_objc_gc:--enable-objc-gc}} \
	#

%make_build MAKEINFOFLAGS=--no-split \
	BOOT_CFLAGS='%optflags' \
	%{?_enable_bootstrap:profiledbootstrap}

%if_enabled doxygen
%make_build -C %_target_platform/libstdc++-v3/doc doc-html-doxygen
%make_build -C %_target_platform/libstdc++-v3/doc doc-man-doxygen
%endif #enabled_doxygen
popd #%buildtarget

%if_with jit
rm -rf %buildtarget-gccjit
mkdir %buildtarget-gccjit
pushd %buildtarget-gccjit

%configure \
	$CONFIGURE_OPTS \
	--disable-bootstrap \
	--enable-host-shared \
	--enable-languages=jit \
	--with-gcc-major-version-only \
	#

%make_build MAKEINFOFLAGS=--no-split \
	BOOT_CFLAGS='%optflags' all-gcc

popd # %%buildtarget-gccjit

cp -a %buildtarget-gccjit/gcc/libgccjit.so* %buildtarget/gcc/

pushd %buildtarget/gcc/
cp -a Makefile{,.orig}
sed -e '/^CHECK_TARGETS/s/$/ check-jit/' -i Makefile
sed -e "s,^lang\.\(.*\):.*,& jit.\1," -i Makefile
touch -r Makefile.orig Makefile
rm Makefile.orig
popd # %%buildtarget/gcc/

%endif # with_jit

# build printable documentation
%if_with pdf
(cd gcc/doc; for f in gcc cpp cppinternals; do
  texi2dvi -p -t @afourpaper -t @finalout -I ../doc/include $f.texi
done)
%endif #with_pdf

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
cd %buildtarget
%make_build -k check ||:
../contrib/test_summary ||:

%install
mkdir -p %buildroot%gcc_custom_libdir

# Copy various doc files here and there
CopyDocs()
{
	local n="$1"
	shift
	mkdir -p "%buildroot%gcc_doc_dir/$n"
	local d="$1"
	shift
	local f
	for f in "$d"/*{README,NEWS,LICENSE,THREADS}*; do
		[ -f "$f" ] || continue
		install -pv -m644 "$f" "%buildroot%gcc_doc_dir/$n/"
	done
}

CopyDocs gcc gcc

CopyDocs g++ gcc/cp
CopyDocs libstdc++ libstdc++-v3
cp -av libstdc++-v3/doc/html %buildroot%gcc_doc_dir/libstdc++/
if [ -d %buildtarget/%_target_platform/libstdc++-v3/doc/doxygen/html ]; then
	cp -a %buildtarget/%_target_platform/libstdc++-v3/doc/doxygen/html \
		%buildroot%gcc_doc_dir/libstdc++/
fi
if [ -d %buildtarget/%_target_platform/libstdc++-v3/doc/doxygen/man ]; then
	cp -a %buildtarget/%_target_platform/libstdc++-v3/doc/doxygen/man/man3 \
		%buildroot%_mandir/
fi

%if_with objc
CopyDocs libobjc libobjc
%endif #with_objc

pushd %buildtarget
%make_install install DESTDIR=%buildroot
popd #%buildtarget

# Remove install-tools.
rm -r %buildroot%gcc_target_libdir/install-tools

# Rename binaries which will be packaged under alternatives control.
pushd %buildroot%_bindir
	rm -vf %gcc_target_platform-gcc-%version {%gcc_target_platform-,}c++%psuffix
	for n in \
	  cpp \
	  gcc gcov gcov-tool gcov-dump \
	  g++ \
	  lto-dump \
	  ; do
		[ -f "%gcc_target_platform-$n%psuffix" ] ||
			mv -v "$n%psuffix" "%gcc_target_platform-$n%psuffix"
	done
popd

# Function that moves shared objects of the common custom libs
# to one specific dir and rest of the files to the other dir
# (with exception for the *gdb.py* files)
moving_libs(){
       for f in *.so*; do
               case "$f" in
                       *gdb.py*)
                               ;;
                       *)
                               mv "$f" "%buildroot%gcc_custom_libdir/"
                               ;;
               esac
       done
       }
# Dealing with /usr/lib64/* libs and symlinks

# Hardlink merged lto1 and lto-dump.
cmp %buildroot%gcc_target_libdir/lto1 \
	%buildroot%_bindir/%gcc_target_platform-lto-dump%psuffix

ln -f %buildroot%gcc_target_libdir/lto1 \
	%buildroot%_bindir/%gcc_target_platform-lto-dump%psuffix

ln -f %buildroot%_bindir/%gcc_target_platform-lto-dump%psuffix \
      %buildroot%_bindir/lto-dump%psuffix

# Hardlink %_bindir/cpp%psuffix
ln -f %buildroot%_bindir/%gcc_target_platform-cpp%psuffix \
      %buildroot%_bindir/cpp%psuffix

pushd %buildroot%_libdir
	rm lib*.la
	rm libssp*
	rm libiberty.a ||:
	mv *.a %buildroot%gcc_target_libdir/
%ifnarch mips s390x
	mv *.o %buildroot%gcc_target_libdir/
%endif
	for f in *.so; do
		[ "$f" != libcc1.so ] || continue
       case "$f" in
                       *gdb.py*)
                               ;;
                       *)
                               v=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
                               [ -f "$v" ]
                               ln -s "%gcc_custom_libdir/$v" "%buildroot%gcc_target_libdir/$f"
                               rm "$f"
                               ;;
               esac
	done
    moving_libs
popd
# Dealing with /lib64/* libs and symlinks
pushd %buildroot/%_lib
	for f in *.so; do
		if v="$(readlink "$f")"; then
			ln -s "%gcc_custom_libdir/$v" "%buildroot%gcc_target_libdir/$f"
			rm "$f"
		else
			mv "$f" "%buildroot%gcc_target_libdir/"
		fi
	done
	moving_libs
popd

# Relocate itm, gomp and gfortran files.
%ifarch %libitm_arches
mv %buildroot%_libdir/libitm.spec %buildroot%gcc_target_libdir/
%endif
mv %buildroot%_libdir/libgomp.spec %buildroot%gcc_target_libdir/
%if_with libsanitizer
mv %buildroot%_libdir/libsanitizer.spec %buildroot%gcc_target_libdir/
%endif

# Remove precompiled headers.
rm -rf %buildroot%_includedir/c++/*/*/*/*.gch

%ifarch x86_64
mkrel32()
{
	local d32=$1 d64=$2 rel; shift 2
	mkdir -p %buildroot$d32
	rel=$(relative $d32 $d64/32)
	ln -s $rel %buildroot$d64/32
}

mkrel32 %gcc_target_lib32dir %gcc_target_libdir
mkrel32 %gxx32idir %gxx64idir
%endif # x86_64

# buildreq ignore rules.
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%marker-%name <<EOF
^%gcc_target_libdir(/include)?$
EOF

# no valid g++ manpage exists in 4.1+ series.
rm %buildroot%_man1dir/g++%psuffix.1
ln -s gcc%psuffix.1.xz %buildroot%_man1dir/g++%psuffix.1.xz

mkdir -p %buildroot%gcc_gdb_auto_load
mv -f %buildroot%_libdir/libstdc++*gdb.py* %buildroot%gcc_gdb_auto_load
pushd libstdc++-v3/python
for i in `find . -name \*.py`; do
  touch -r $i %buildroot%_datadir/gcc%psuffix/python/$i
done
touch -r hook.in %buildroot%gcc_gdb_auto_load/libstdc++*gdb.py
popd

%find_lang gcc%psuffix
%find_lang --append --output gcc%psuffix.lang cpplib%psuffix

%if_with jit
ln -s libgccjit.so.0 %buildroot%_libdir/%marker-gcc/libgccjit.so
%endif #with_jit
# Moving info files into subdir
pushd %buildroot%_infodir
       mkdir %marker-%name
       mv cpp*.info* gcc*.info* libitm.info* libgomp*.info* \
                libgccjit.info* %marker-%name
popd

%if_enabled source
mkdir -p %buildroot%gcc_sourcedir
cp %SOURCE0 %buildroot%gcc_sourcedir/
%endif
%if_enabled precompat
%define _deps_optimization 0
%endif

# Finding out what custom libraries do provide
%add_findprov_lib_path %gcc_custom_libdir

%files -n %marker-%name
%config %_sysconfdir/buildreqs/files/ignore.d/%marker-%name
%dir %gcc_doc_dir/
%gcc_doc_dir/gcc/
%_bindir/gcc%psuffix
%_bindir/gcc-ar%psuffix
%_bindir/gcc-nm%psuffix
%_bindir/gcc-ranlib%psuffix
%_bindir/lto-dump%psuffix
%_bindir/%gcc_target_platform-gcc%psuffix
%_bindir/%gcc_target_platform-gcov%psuffix
%_bindir/%gcc_target_platform-gcov-tool%psuffix
%_bindir/%gcc_target_platform-gcov-dump%psuffix
%_bindir/%gcc_target_platform-gcc-ar%psuffix
%_bindir/%gcc_target_platform-gcc-nm%psuffix
%_bindir/%gcc_target_platform-gcc-ranlib%psuffix
%_bindir/%gcc_target_platform-lto-dump%psuffix
%_man1dir/gcc%psuffix.*
%_man1dir/gcov%psuffix.*
%_man1dir/gcov-tool%psuffix.*
%_man1dir/gcov-dump%psuffix.*
%_man1dir/lto-dump%psuffix.*
%dir %gcc_target_libdir/
%dir %gcc_target_libdir/include/
%gcc_target_libdir/include/float.h
%gcc_target_libdir/include/gcov.h
%gcc_target_libdir/include/iso646.h
%gcc_target_libdir/include/limits.h
%gcc_target_libdir/include/stdalign.h
%gcc_target_libdir/include/stdarg.h
%gcc_target_libdir/include/stdatomic.h
%gcc_target_libdir/include/stdbool.h
%gcc_target_libdir/include/stddef.h
%gcc_target_libdir/include/stdfix.h
%gcc_target_libdir/include/stdint-gcc.h
%gcc_target_libdir/include/stdint.h
%gcc_target_libdir/include/stdnoreturn.h
%gcc_target_libdir/include/syslimits.h
%gcc_target_libdir/include/unwind.h
%gcc_target_libdir/include/varargs.h

%ifarch aarch64
%gcc_target_libdir/include/arm_sve.h
%endif
%ifarch aarch64 armh
%gcc_target_libdir/include/arm_acle.h
%gcc_target_libdir/include/arm_bf16.h
%gcc_target_libdir/include/arm_fp16.h
%gcc_target_libdir/include/arm_neon.h
%endif
%ifarch armh
%gcc_target_libdir/include/arm_cde.h
%gcc_target_libdir/include/arm_cmse.h
%gcc_target_libdir/include/arm_mve.h
%gcc_target_libdir/include/arm_mve_types.h
%endif
%ifarch armh arm
%gcc_target_libdir/include/mmintrin.h
%gcc_target_libdir/include/unwind-arm-common.h
%endif
%ifarch mips mipsel
%gcc_target_libdir/include/loongson.h
%gcc_target_libdir/include/msa.h
%endif
%ifarch s390x
%gcc_target_libdir/include/*intrin*.h
%endif
%ifarch %ix86 x86_64
%gcc_target_libdir/include/*intrin*.h
%gcc_target_libdir/include/cet.h
%gcc_target_libdir/include/cpuid.h
%gcc_target_libdir/include/cross-stdarg.h
%gcc_target_libdir/include/mm3dnow.h
%gcc_target_libdir/include/mm_malloc.h
%endif
%ifarch ppc ppc64 ppc64le
%gcc_target_libdir/include/*intrin*.h
%gcc_target_libdir/include/altivec.h
%gcc_target_libdir/include/amo.h
%gcc_target_libdir/include/mm_malloc.h
%gcc_target_libdir/include/ppc-asm.h
%gcc_target_libdir/include/rs6000-vecdefines.h
%gcc_target_libdir/include/si2vmx.h
%gcc_target_libdir/include/spu2vmx.h
%gcc_target_libdir/include/vec_types.h
%endif
%ifarch ppc ppc64
%gcc_target_libdir/include/spe.h
%endif
%ifarch riscv64
%gcc_target_libdir/include/riscv_vector.h
%endif
%ifarch loongarch64
%gcc_target_libdir/include/larchintrin.h
%gcc_target_libdir/include/pthread.h
%endif
%ifarch ppc64le
%gcc_target_libdir/ecrt*.o
%gcc_target_libdir/ncrt*.o
%endif
%gcc_target_libdir/crt*.o
%gcc_target_libdir/libgcc_s.so
%gcc_target_libdir/libgcc*.a
%gcc_target_libdir/libgcov.a
%ifarch %libatomic_arches
%gcc_target_libdir/libatomic.so
%endif
%ifarch %libasan_arches
%gcc_target_libdir/libasan_preinit.o
%gcc_target_libdir/libasan.so
%endif
%ifarch %libhwasan_arches
%gcc_target_libdir/include/sanitizer/hwasan_interface.h
%gcc_target_libdir/libhwasan.so
%gcc_target_libdir/libhwasan_preinit.o
%endif
%ifarch %libitm_arches
%gcc_target_libdir/libitm.so
%gcc_target_libdir/libitm.spec
%endif
%ifarch %libtsan_arches
%gcc_target_libdir/include/sanitizer/tsan_interface.h
%gcc_target_libdir/libtsan.so
%gcc_target_libdir/libtsan_preinit.o
%endif
%ifarch %liblsan_arches
%gcc_target_libdir/liblsan.so
%gcc_target_libdir/liblsan_preinit.o
%endif
%ifarch %libubsan_arches
%gcc_target_libdir/libubsan.so
%endif
%ifarch %libvtv_arches
%gcc_target_libdir/libvtv.so
%endif
%if_with libsanitizer
%gcc_target_libdir/libsanitizer.spec
%dir %gcc_target_libdir/include/sanitizer/
%gcc_target_libdir/include/sanitizer/common_interface_defs.h
%endif
%ifarch x86_64
%dir %gcc_target_lib32dir/
%gcc_target_libdir/32
%endif
%dir %gcc_target_libdir/plugin/
%gcc_target_libdir/collect2
%gcc_target_libdir/lto-wrapper
%gcc_target_libdir/lto1
%attr(0755,root,root) %gcc_target_libdir/liblto_plugin.so*
%gcc_target_libdir/plugin/gengtype

%exclude %gcc_target_libdir/include-fixed
%exclude %gcc_target_libdir/include/ssp
%exclude %gcc_target_libdir/plugin/gtype.state
%exclude %gcc_target_libdir/plugin/libcc1plugin.la
%exclude %gcc_target_libdir/plugin/libcp1plugin.la
%exclude %gcc_target_libdir/liblto_plugin.la
%exclude %_datadir/locale/de/LC_MESSAGES/libstdc++.mo
%exclude %_datadir/locale/fr/LC_MESSAGES/libstdc++.mo
%exclude %_man7dir/fsf-funding.7*
%exclude %_man7dir/gfdl.7*
%exclude %_man7dir/gpl.7*

%if_disabled compat
%files -n %marker-libgcc1
%dir %gcc_custom_libdir/
%gcc_custom_libdir/libgcc_s.so.*

%ifarch %libatomic_arches
%files -n %marker-libatomic1
%gcc_custom_libdir/libatomic.so.*
%endif

%ifarch %libasan_arches
%files -n %marker-libasan8
%gcc_custom_libdir/libasan.so.8*
%endif

%ifarch %libhwasan_arches
%files -n %marker-libhwasan0
%gcc_custom_libdir/libhwasan.so.0*
%endif

%ifarch %libtsan_arches
%files -n %marker-libtsan2
%gcc_custom_libdir/libtsan.so.2*
%endif

%ifarch %libitm_arches
%files -n %marker-libitm1
%gcc_custom_libdir/libitm.so.1*
%endif

%files -n %marker-libgomp1
%gcc_custom_libdir/libgomp.so.1*

%ifarch %liblsan_arches
%files -n %marker-liblsan0
%gcc_custom_libdir/liblsan.so.0*
%endif

%ifarch %libubsan_arches
%files -n %marker-libubsan1
%gcc_custom_libdir/libubsan.so.1*
%endif

%ifarch %libquadmath_arches
%files -n %marker-libquadmath0
%gcc_custom_libdir/libquadmath.so.0*
%endif

%ifarch %libvtv_arches
%files -n %marker-libvtv0
%gcc_custom_libdir/libvtv.so.0*
%endif
%endif #compat

%files -n %marker-%name-plugin-devel
%dir %gcc_target_libdir/plugin/
%gcc_target_libdir/plugin/include/

%ifarch %libatomic_arches
%files -n %marker-libatomic%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libatomic.a
%endif

%ifarch %libasan_arches
%files -n %marker-libasan%gcc_branch-devel-static
%dir %gcc_target_libdir/
%dir %gcc_target_libdir/include/
%dir %gcc_target_libdir/include/sanitizer/
%gcc_target_libdir/include/sanitizer/asan_interface.h
%gcc_target_libdir/libasan.a
%endif

%ifarch %libhwasan_arches
%files -n %marker-libhwasan%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libhwasan.a
%endif

%ifarch %libtsan_arches
%files -n %marker-libtsan%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libtsan.a
%endif

%files -n %marker-libgomp%gcc_branch-devel
%dir %gcc_target_libdir/
%dir %gcc_target_libdir/include/
%gcc_target_libdir/include/acc_prof.h
%gcc_target_libdir/include/omp.h
%gcc_target_libdir/include/openacc.h
%gcc_target_libdir/libgomp.so
%gcc_target_libdir/libgomp.spec

%files -n %marker-libgomp%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libgomp.a

%ifarch %libitm_arches
%files -n %marker-libitm%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libitm.a
%endif

%ifarch %libquadmath_arches
%files -n %marker-libquadmath%gcc_branch-devel
%dir %gcc_target_libdir/
%dir %gcc_target_libdir/include/
%gcc_target_libdir/include/quadmath.h
%gcc_target_libdir/include/quadmath_weak.h
%gcc_target_libdir/libquadmath.so

%files -n %marker-libquadmath%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libquadmath.a
%endif

%ifarch %liblsan_arches
%files -n %marker-liblsan%gcc_branch-devel-static
%dir %gcc_target_libdir/
%dir %gcc_target_libdir/include/
%dir %gcc_target_libdir/include/sanitizer/
%gcc_target_libdir/include/sanitizer/lsan_interface.h
%gcc_target_libdir/liblsan.a
%endif

%ifarch %libubsan_arches
%files -n %marker-libubsan%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libubsan.a
%endif

%ifarch %libvtv_arches
%files -n %marker-libvtv%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libvtv.a
%endif

%files -n %marker-cpp%gcc_branch
%_bindir/cpp%psuffix
%_bindir/%gcc_target_platform-cpp%psuffix
%_man1dir/cpp%psuffix.*
%gcc_target_libdir/cc1

%if_disabled compat
%files -n %marker-libstdc++6
%dir %gcc_custom_libdir/
%gcc_custom_libdir/libstdc++.so.*
%dir %gcc_gdb_auto_load/
%gcc_gdb_auto_load/libstdc*gdb.py*
%dir %_datadir/gcc%psuffix/
%_datadir/gcc%psuffix/python/
%endif # compat

%files -n %marker-libstdc++%gcc_branch-devel
%dir %gcc_doc_dir/
%gcc_doc_dir/libstdc++
%_includedir/c++/*
%dir %gcc_target_libdir/
%gcc_target_libdir/libstdc++.so
%gcc_target_libdir/libsupc++.a
%ifarch x86_64
%dir %gxx32idir/
%gxx64idir/32
%endif

%files -n %marker-libstdc++%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libstdc++.a
%gcc_target_libdir/libstdc++exp.a
%gcc_target_libdir/libstdc++fs.a

%files -n %marker-%name-c++
%dir %gcc_doc_dir/
%gcc_doc_dir/g++
%_bindir/g++%psuffix
%_bindir/%gcc_target_platform-g++%psuffix
%_man1dir/g++%psuffix.*
%gcc_target_libdir/cc1plus
%gcc_target_libdir/g++-mapper-server
%ifarch %libvtv_arches
%gcc_target_libdir/vtv_*.o
%gcc_target_libdir/include/vtv_*.h
%endif

%if_with objc
%if_disabled compat
%files -n %marker-libobjc4
%gcc_custom_libdir/libobjc*.so.4*
%endif # compat

%files -n %marker-libobjc%gcc_branch-devel
%dir %gcc_doc_dir/
%gcc_doc_dir/libobjc/
%dir %gcc_target_libdir/
%gcc_target_libdir/libobjc*.so
%dir %gcc_target_libdir/include/
%gcc_target_libdir/include/objc/

%files -n %marker-libobjc%gcc_branch-devel-static
%dir %gcc_target_libdir/
%gcc_target_libdir/libobjc*.a

%files -n %marker-%name-objc
%gcc_target_libdir/cc1obj

%files -n %marker-%name-objc++
%gcc_target_libdir/cc1objplus
%endif #with_objc

%if_with jit
%files -n %marker-libgccjit0
%gcc_custom_libdir/libgccjit.so.0*

%files -n %marker-libgccjit%gcc_branch-devel
%gcc_custom_libdir/libgccjit.so
%_includedir/libgccjit*.h
%gcc_target_libdir/libgccjit.so
%endif #with_jit

%if_disabled compat
%files -n %marker-%name-gdb-plugin
%gcc_custom_libdir/libcc1.so
%gcc_target_libdir/plugin/libcc1plugin.so
%gcc_target_libdir/plugin/libcp1plugin.so
%endif # disable_compat

%if_enabled source
%files -n %marker-%name-source
%gcc_sourcedir
%endif

%files -n %marker-%name-locales -f gcc%psuffix.lang

%files -n %marker-%name-doc
%{?_enable_doxygen:%_man3dir/*}
%_infodir/%marker-%name/cpp*.info*
%_infodir/%marker-%name/gcc*.info*
%ifarch %libitm_arches
%_infodir/%marker-%name/libitm.info*
%endif
%_infodir/%marker-%name/libgomp*.info*
%{?_with_jit:%_infodir/%marker-%name/libgccjit.info*}

%if_with pdf
%doc gcc/doc/cpp*.pdf
%doc gcc/doc/gcc*.pdf
%endif #with_pdf

%changelog
