%define        pkgname opengl

Name:          gem-%pkgname
Epoch:         1
Version:       0.10.0
Release:       alt1.4
Summary:       OpenGL Interface for Ruby
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/larskanis/opengl
Vcs:           https://github.com/larskanis/opengl.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libGL-devel
BuildRequires: libX11-devel
BuildRequires: libfreeglut-devel
BuildRequires: gem(hoe)
BuildRequires: gem(rake-compiler)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency bundler >= 2.2,bundler < 3
%ruby_use_gem_dependency rake-compiler-dock >= 1.1.0,rake-compiler-dock < 2
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
ruby-opengl consists of Ruby extension modules that are bindings for
the OpenGL, GLU, and GLUT libraries. It is intended to be a replacement
for -- and uses the code from -- Yoshi's ruby-opengl.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch
Provides:      doc
Obsoletes:     doc

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       -n gem-%pkgname-devel
Summary:       Development headers files for %gemname gem
Summary(ru_RU.UTF-8): Файлы заголовков для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   -n gem-%pkgname-devel
Development headers for %gemname gem.

%description   -n gem-%pkgname-devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-%pkgname-doc
%ruby_gemdocdir

%files         -n gem-%pkgname-devel
%ruby_includedir/*


%changelog
