%define _unpackaged_files_terminate_build 1

Name: gl2ps
Version: 1.4.2
Release: alt1.1
Summary: OpenGL to PostScript printing library
License: LGPLv2+
Group: Graphics
Url: http://geuz.org/gl2ps/#tth_sEc5

# https://gitlab.onelab.info/gl2ps/gl2ps.git
Source: %name-%version.tar

Patch1: %name-%version-alt-build.patch

BuildRequires: cmake zlib-devel libpng-devel ghostscript-utils
BuildRequires: libGLU-devel libGLUT-devel libXi-devel libXmu-devel
BuildRequires: libICE-devel libSM-devel libXres-devel libXext-devel
BuildRequires: libXtst-devel libXau-devel libXcomposite-devel
BuildRequires: libXcursor-devel libXdamage-devel libXdmcp-devel
BuildRequires: libXfixes-devel libXft-devel libXinerama-devel
BuildRequires: libXpm-devel libXrandr-devel libXrender-devel
BuildRequires: libXScrnSaver-devel libXt-devel libXv-devel
BuildRequires: libXxf86misc-devel libXxf86vm-devel libxkbfile-devel
BuildRequires: texlive-dist

%description
GL2PS is a C library providing high quality vector output for any OpenGL
application. The main difference between GL2PS and other similar
libraries is the use of sorting algorithms capable of handling
intersecting and stretched polygons, as well as non manifold objects.
GL2PS provides advanced smooth shading and text rendering, culling of
invisible primitives, mixed vector/bitmap output, and much more.

%package -n lib%name
Summary: Shared libraries of GL2PS
Group: System/Libraries

%description -n lib%name
GL2PS is a C library providing high quality vector output for any OpenGL
application. The main difference between GL2PS and other similar
libraries is the use of sorting algorithms capable of handling
intersecting and stretched polygons, as well as non manifold objects.
GL2PS provides advanced smooth shading and text rendering, culling of
invisible primitives, mixed vector/bitmap output, and much more.

This package contains shared libraries of GL2PS.

%package -n lib%name-devel
Summary: Development files of GL2PS
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
GL2PS is a C library providing high quality vector output for any OpenGL
application. The main difference between GL2PS and other similar
libraries is the use of sorting algorithms capable of handling
intersecting and stretched polygons, as well as non manifold objects.
GL2PS provides advanced smooth shading and text rendering, culling of
invisible primitives, mixed vector/bitmap output, and much more.

This package contains development files of GL2PS.

%package -n lib%name-devel-doc
Summary: Documentation for GL2PS
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
GL2PS is a C library providing high quality vector output for any OpenGL
application. The main difference between GL2PS and other similar
libraries is the use of sorting algorithms capable of handling
intersecting and stretched polygons, as well as non manifold objects.
GL2PS provides advanced smooth shading and text rendering, culling of
invisible primitives, mixed vector/bitmap output, and much more.

This package contains development documentation for GL2PS.

%prep
%setup
%patch1 -p1

%build
%cmake

%cmake_build

%install
%cmake_install

%files -n lib%name
%doc README.txt TODO.txt
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%files -n lib%name-devel-doc
%_docdir/%name

%changelog
