%define ver_major 3.8
%def_disable gnome

Name: glade3
Version: %ver_major.6
Release: alt2

Summary: GTK+2%{?_enable_gnome:/GNOME2} widget builder
Group: Development/GNOME and GTK+
License: %gpl2plus, %lgpl2plus
Url: http://glade.gnome.org/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# Sonames of libgladeui don't change with each release. Although ABI does
# not change either, it is better to upgrade libgladeui along with glade3.
Requires: libgladeui = %version-%release

BuildPreReq: rpm-build-licenses rpm-build-gnome

# From configure.ac
BuildPreReq: intltool >= 0.35.0 yelp-tools
BuildPreReq: gnome-common
BuildPreReq: gtk-doc >= 1.9
BuildPreReq: libgtk+2-devel >= 2.24.0
BuildPreReq: libxml2-devel >= 2.4.0
%{?_enable_gnome:BuildRequires: libbonoboui-devel libgnomeui-devel}
BuildPreReq: python-module-pygtk-devel >= 2.10.0

%description
Glade 3 is a Widget builder for Gtk/gnome.
It allows to create a gtk/gnome interface files
that can be loaded with libglade.

%package -n libgladeui
Summary: GTK+2/GNOME2 widget builder library
Group: Development/GNOME and GTK+
Obsoletes: libgladeui3.6
Obsoletes: libgladeui3.7

%description -n libgladeui
Glade 3 is a Widget builder for Gtk/gnome.
It allows to create a gtk/gnome interface files
that can be loaded with libglade.

This is library that can be used for embed builder
into other application.

%package -n libgladeui-devel
Summary: GTK+2/GNOME2 widget builder library
Group: Development/GNOME and GTK+
Requires: libgladeui = %version-%release
Obsoletes: libgladeui3.6-devel
Obsoletes: libgladeui3.7-devel

%description -n libgladeui-devel
Glade 3 is a Widget builder for Gtk/gnome.
It allows to create a gtk/gnome interface files
that can be loaded with libglade.

This package contains development files for library.

%prep
%setup
# itstool > 2.0.2 segfaults on bg and uk helps
for tr in bg uk; do
subst "s/$tr //" help/Makefile.am
done

%build
%autoreconf
%configure --disable-dependency-tracking \
	--disable-scrollkeeper \
	%{subst_enable gnome}

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name
%find_lang --with-gnome glade

cat %name.lang glade.lang > lang

%files -f lang
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%doc AUTHORS COPYING NEWS README TODO

%files -n libgladeui
%dir %_libdir/%name
%dir %_libdir/%name/modules
%_libdir/%name/modules/*.so
%_libdir/*.so.*
%dir %_datadir/%name
%dir %_datadir/%name/catalogs
%_datadir/%name/catalogs/*.xml
%_datadir/%name/catalogs/*.xml.in
%_datadir/%name/catalogs/glade-catalog.dtd
%_datadir/%name/pixmaps

%files -n libgladeui-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/gtk-doc/html/*

%exclude %_libdir/glade3/modules/*.la

%changelog
