# since 3.29.x depends on modules in %_libdir/%%name
%set_verify_elf_method unresolved=relaxed

%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 40
%define xdg_name org.gnome.Boxes
%def_disable ovirt
%def_disable installed_tests

Name: gnome-boxes
Version: %ver_major.3
Release: alt1

Summary: A simple GNOME 3 application to access remote or virtual systems
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
Group: Emulators
License: LGPL-2.0
Url: https://wiki.gnome.org/Apps/Boxes

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define govirt_ver 0.3.4
%define glib_ver 2.50.0
%define gtk_ver 3.22.20
%define gtk_vnc_ver 0.4.4
%define libvirt_glib_ver 4.0.0
%define libxml2_ver 2.7.8
%define libusb_ver 1.0.9
%define spice_gtk_ver 0.32
%define gudev_ver 165
%define osinfo_ver 0.2.12
%define tracker_ver 3.0
%define uuid_ver 1.41.3
%define libsoup_ver 2.38
%define libarchive_ver 3.0.0
%define vte_ver 0.40.2
%define webkit_ver 2.26

Requires: gnome-keyring dconf

# Need libvirtd and an hypervisor to do anything useful
Requires: libvirt-daemon
Requires: qemu-kvm

# Needed for unattended installations
Requires: fuseiso
Requires: mtools

BuildRequires(pre): meson
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: gobject-introspection-devel >= 0.9.6
BuildRequires: libvala-devel >= 0.28.0.16
BuildRequires: vala-tools
BuildRequires: glib2-devel >= %glib_ver libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libgtk+3-gir-devel
BuildRequires: libgtk3vnc-devel >= %gtk_vnc_ver
BuildRequires: libsecret-devel libsecret-gir-devel
BuildRequires: libvirt-gobject-devel >= %libvirt_glib_ver
BuildRequires: libvirt-gconfig-devel >= %libvirt_glib_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libusb-devel >= %libusb_ver
BuildRequires: pkgconfig(spice-client-gtk-3.0) >= %spice_gtk_ver
BuildRequires: libgudev-devel >= %gudev_ver
BuildRequires: libosinfo-devel >= %osinfo_ver
BuildRequires: pkgconfig(tracker-sparql-3.0) >= %tracker_ver
BuildRequires: libuuid-devel >= %uuid_ver
BuildRequires: libsoup-devel >= %libsoup_ver
BuildRequires: libarchive-devel >= %libarchive_ver
%{?_enable_ovirt:BuildRequires: pkgconfig(govirt-1.0) >= %govirt_ver}
BuildRequires: libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libfreerdp-devel
BuildRequires: libvte3-devel >= %vte_ver
BuildRequires: pkgconfig(gtksourceview-4)
BuildRequires: pkgconfig(libhandy-1)

%description
gnome-boxes lets you easily create, setup, access, and use:
  * remote machines
  * remote virtual machines
  * local virtual machines
  * When technology permits, set up access for applications on
    local virtual machines

%package tests
Summary: Tests for the Boxes
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the Boxes.


%prep
%setup

%build
%meson \
	%{?_disable_ovirt:-Dovirt=false} \
	%{?_enable_installed_tests:-Dinstalled_tests=true}
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%files -f %name.lang
%doc AUTHORS README* NEWS
%_bindir/%name
%_libdir/%name/
%_datadir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/org.gnome.boxes.gschema.xml
#%_datadir/osinfo/os/gnome.org/gnome-nightly.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*
%_libexecdir/gnome-boxes-search-provider
%_datadir/dbus-1/services/*.service
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_datadir/metainfo/*.xml

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif

%exclude %_includedir/%name/

%changelog
