%def_enable snapshot

%define xdg_name org.gnome.Builder
%define ver_major 3.40
%define _libexecdir %_prefix/libexec
%define api_ver 1.0

%def_with sysprof
%def_with flatpak
%def_with docs
%def_with help
%def_with autotools
%def_with jedi
# disabled by default
%def_with vala
# Vala Language Server integration plugin
%def_without gvls
# Rust Language Server integration plugin (disabled by default)
%def_without rls

Name: gnome-builder
Version: %ver_major.2
Release: alt1.1

Summary: Builder - Develop software for GNOME
License: LGPLv2+
Group: Development/GNOME and GTK+
Url: https://wiki.gnome.org/Apps/Builder

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%set_typelibdir %_libdir/%name/girepository-1.0

%define glib_ver 2.67.0
%define gtk_ver 3.22.26
%define gtksourceview_ver 4.6.1
%define git2_ver 0.28.0.1
%define devhelp_ver 3.30.0
%define gjs_ver 1.42
%define xml_ver 2.9.0
%define vala_ver 0.37
%define sysprof_ver 3.34.0
%define vte_ver 0.46
%define gtkmm_ver 3.20
%define gspell_ver 1.8.0
%define peas_ver 1.22.0
%define json_glib_ver 1.2.0
%define dazzle_ver 3.37.0
%define template_glib_ver 3.34.0
%define soup_ver 2.52
%define webkit_ver 2.26
%define portal_ver 0.3

%add_python3_path %_libdir/%name/plugins
%add_findreq_skiplist %_datadir/%name/plugins/*_templates/resources/*/*.py

Requires(pre): %name-data = %EVR
# src/libide/gui/ide-application-plugins.c
Requires: typelib(WebKit2) = 4.0
Requires: typelib(Jsonrpc) = 1.0

%{?_with_autotools:Requires: automake autoconf libtool}
#%{?_with_flatpak:Requires: flatpak-builder}
Requires: meson git indent xmllint
Requires: devhelp uncrustify %_bindir/ctags
Requires: libpeas-python3-loader
#%%{?_with_jedi:Requires: python3-module-jedi}

BuildRequires(pre): meson rpm-build-python3 rpm-build-gir
BuildRequires: /proc gcc-c++ flex mm-common yelp-tools gtk-doc
BuildRequires: ctags
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libappstream-glib-devel desktop-file-utils
BuildRequires: llvm-devel clang-devel libgtk+3-devel >= %gtk_ver
BuildRequires: libgtksourceview4-devel >= %gtksourceview_ver
BuildRequires: libgit2-glib-devel >= %git2_ver libdevhelp-devel >= %devhelp_ver
BuildRequires: libpcre-devel libgjs-devel >= %gjs_ver libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libxml2-devel >= %xml_ver libpeas-devel >= %peas_ver libvte3-devel >= %vte_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver libpcre2-devel
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libvte3-gir-devel
BuildRequires: libgtksourceview4-gir-devel libgit2-glib-gir-devel libpeas-gir-devel
BuildRequires: libjson-glib-gir-devel libsoup-devel >= %soup_ver
BuildRequires: libvala-devel >= %vala_ver vala-tools
BuildRequires: libgspell-devel >= %gspell_ver libenchant2-devel
BuildRequires: libdazzle-devel >= %dazzle_ver libtemplate-glib-devel >= %template_glib_ver libjsonrpc-glib-devel
BuildRequires: libdazzle-gir-devel libtemplate-glib-gir-devel  libjsonrpc-glib-gir-devel
BuildRequires: libgtkmm3-devel >= %gtkmm_ver
BuildRequires: libgladeui2.0-devel
%{?_with_help:BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme}
%{?_with_flatpak:BuildRequires: libflatpak-devel libostree-devel libportal-devel >= %portal_ver}
%{?_with_sysprof:BuildRequires: sysprof-devel >= %sysprof_ver}

%description
Builder attempts to be an IDE for writing software for GNOME. It does not
try to be a generic IDE, but one specialized for writing GNOME software.
We believe that this focus will help us to build something great.

%package data
Summary: Arch independent files for GNOME Builder
Group: Development/GNOME and GTK+
BuildArch: noarch

%description data
This package provides noarch data needed for Gnome Builder to work.

%package clang
Summary: Clang/LLVW dependent part for GNOME Builder
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description clang
This package provides files for Gnome Builder to work with Clang/LLVW.


%prep
%setup
sed -i 's|\(#\!/usr/bin/env python\)$|\13|' src/plugins/*/*.py

%build
%meson \
	%{?_with_docs:-Ddocs=true} \
	%{?_with_help:-Dhelp=true} \
	%{?_without_flatpak:-Dplugin_flatpak=false} \
	%{?_with_autotools:-Dplugin_autotools=true} \
	%{?_with_gvls:-Dplugin_gvls=true} \
	%{?_with_rls:-Dplugin_rls=true}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-git
%dir %_libdir/%name

%dir %_libdir/%name/girepository-1.0
%_libdir/%name/girepository-1.0/Ide-%ver_major.typelib

%dir %_libdir/%name/plugins
%_libdir/%name/plugins/__pycache__
%_libdir/%name/plugins/cargo.plugin
%_libdir/%name/plugins/cargo_plugin.py
%_libdir/%name/plugins/copyright.plugin
%_libdir/%name/plugins/copyright_plugin.py
%_libdir/%name/plugins/eslint.plugin
%_libdir/%name/plugins/eslint_plugin.py
%_libdir/%name/plugins/find-other-file.plugin
%_libdir/%name/plugins/find_other_file.py
%_libdir/%name/plugins/gjs_symbols.plugin
%_libdir/%name/plugins/gjs_symbols.py
%_libdir/%name/plugins/go-langserv.plugin
%_libdir/%name/plugins/go_langserver_plugin.py
%{?_with_gvls:%_libdir/%name/plugins/gvls.plugin
%_libdir/%name/plugins/gvls_plugin.py}
%_libdir/%name/plugins/gradle.plugin
%_libdir/%name/plugins/gradle_plugin.py
%_libdir/%name/plugins/gvls.plugin
%_libdir/%name/plugins/gvls_plugin.py
%_libdir/%name/plugins/html-preview.plugin
%_libdir/%name/plugins/html_preview.gresource
%_libdir/%name/plugins/html_preview.py
%_libdir/%name/plugins/jedi.plugin
%_libdir/%name/plugins/jedi_plugin.py
%_libdir/%name/plugins/jhbuild.plugin
%_libdir/%name/plugins/jhbuild_plugin.py
%_libdir/%name/plugins/make.plugin
%_libdir/%name/plugins/make_plugin.gresource
%_libdir/%name/plugins/make_plugin.py
%_libdir/%name/plugins/maven.plugin
%_libdir/%name/plugins/maven_plugin.py
%_libdir/%name/plugins/meson-templates.plugin
%_libdir/%name/plugins/meson_templates.gresource
%_libdir/%name/plugins/meson_templates.py
%_libdir/%name/plugins/mono.plugin
%_libdir/%name/plugins/mono_plugin.py
%_libdir/%name/plugins/npm.plugin
%_libdir/%name/plugins/npm_plugin.py
%_libdir/%name/plugins/phpize.plugin
%_libdir/%name/plugins/phpize_plugin.py
%_libdir/%name/plugins/python-gi-imports-completion.plugin
%_libdir/%name/plugins/python_gi_imports_completion.py
%{?_with_rls:%_libdir/%name/plugins/rls.plugin
%_libdir/%name/plugins/rls_plugin.py}
%_libdir/%name/plugins/stylelint.plugin
%_libdir/%name/plugins/stylelint_plugin.py
%{?_with_vala:%_libdir/%name/plugins/vala-pack.plugin
%_libdir/%name/plugins/vala_pack_plugin.py}
%_libdir/%name/plugins/valgrind.plugin
%_libdir/%name/plugins/valgrind_plugin.gresource
%_libdir/%name/plugins/valgrind_plugin.py
%_libdir/%name/plugins/waf.plugin
%_libdir/%name/plugins/waf_plugin.py
#%{?_with_autotools_templates:%_libdir/%name/plugins/autotools_templates/}
#%{?_with_sysprof:%_libdir/%name/plugins/sysprof-plugin.so}

%_includedir/%name/
%_includedir/%name-%ver_major/
%dir %_libdir/%name/pkgconfig
%_libdir/%name/pkgconfig/%name-%ver_major.pc
%python3_sitelibdir_noarch/gi/overrides/Ide.py
%python3_sitelibdir_noarch/gi/overrides/__pycache__/
%doc README* AUTHORS NEWS

%files clang
%_libexecdir/%name-clang

%files data
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.builder.build.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.clang.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.code-insight.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.editor.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.editor.language.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.extension-type.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.gnome-code-assistance.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugin.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugins.color_picker_plugin.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugins.copyright.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugins.eslint.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugins.stylelint.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.project.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.project-tree.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.terminal.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.workbench.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.rust-analyzer.gschema.xml
%_datadir/gtksourceview-4/styles/*.xml
%_datadir/%name/
%_iconsdir/hicolor/*/*/*.*
%_datadir/metainfo/%xdg_name.appdata.xml

%if_with docs
%_datadir/gtk-doc/html/libide/
%{?_with_help:%_datadir/doc/%name/}
%endif

%changelog
