%define ver_major 1.14
%def_with exiv2
%def_with chm
%def_with taglib
%def_with poppler
%def_with libgsf
%def_with samba
%def_with unique

Name: gnome-commander
Version: %ver_major.3
Release: alt1

%define xdg_name org.gnome.%name

Summary: A Gnome file manager similar to the Norton Commander (TM)
License: GPL-2.0
Group: File tools
Url: https://gcmd.github.io

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define gtk_ver 2.24

Requires: dconf xdg-utils
Requires: %_bindir/gio gvfs

BuildRequires: flex gcc-c++
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: libgtk+2-devel >= %gtk_ver libgnome-keyring-devel gnome-vfs-devel
%{?_with_exiv2:BuildRequires: libexiv2-devel}
%{?_with_libchm:BuildRequires: libchm-devel}
%{?_with_taglib:BuildRequires: libtag-devel}
%{?_with_poppler:BuildRequires: libpoppler-glib-devel}
%{?_with_libgsf:BuildRequires: libgsf-devel}
%{?_with_unique:BuildRequires: libunique-devel}

%description
Gnome Commander is a file manager that just like the classical Norton
Commander (TM) lets you do everything with the keyboard. It can perform
all standard file operations and some extra features like FTP support.

%prep
%setup
%ifarch %e2k
# workaround for EDG frontend
sed -i.e2k "/g_autofree gchar/{s|g_autofree gchar|g_autofree_edg(gchar)|;s|\*||g}" src/gnome-cmd-data.cc
%endif

%build
%autoreconf
%configure --disable-static \
	--disable-schemas-compile \
	%{subst_with exiv2} \
	%{subst_with libchm} \
	%{subst_with taglib} \
	%{subst_with poppler} \
	%{subst_with libgsf} \
	%{subst_with samba} \
	%{subst_with unique}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libdir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/pixmaps/%name.svg
%_datadir/pixmaps/%name/
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/*
%doc AUTHORS ChangeLog NEWS README TODO doc/*.txt

%exclude %_libdir/%name/*.la
%exclude %_libdir/%name/plugins/*.la


%changelog
