%def_disable snapshot
%define ver_major 40
%define beta %nil
%define xdg_name org.gnome.Games
%define _libexecdir %_prefix/libexec

Name: gnome-games
Version: %ver_major.0
Release: alt1%beta

Summary: Simple game launcher for GNOME
License: %gpl3plus
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Games

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define vala_ver 0.48.0

BuildRequires(pre): meson >= 0.50 rpm-build-licenses
BuildRequires: vala-tools >= %vala_ver
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(grilo-0.3)
BuildRequires: pkgconfig(libarchive)
BuildRequires: pkgconfig(librsvg-2.0) >= 2.44
BuildRequires: pkgconfig(libsoup-2.4)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(manette-0.2) >= 0.2.5
BuildRequires: pkgconfig(retro-gtk-1) >= 1.0.0
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(tracker-sparql-2.0)
BuildRequires: pkgconfig(libhandy-1) >= 1.1.90

%description
Games is a GNOME3 application to browse your video games library and to
easily pick and play a game from it.

%package devel
Summary: Development package for GNOME Games
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides files needed to develop plugins for GNOME Games.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-search-provider
%dir %_libdir/%name
%_libdir/%name/plugins/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_datadir/metainfo/%xdg_name.appdata.xml

#%files devel
#%_includedir/lib%name.h
#%_vapidir/%name.vapi


%changelog
