%define _unpackaged_files_terminate_build 1

%define _name lightsoff
%define xdg_name org.gnome.LightsOff
%define ver_major 40
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.0.1
Release: alt1

Summary: Lights Off is a puzzle game
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Lightsoff

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

Provides:  %_name = %version-%release

%define glib_ver 2.40.0
%define gtk_ver 3.22.0

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: gsettings-desktop-schemas-devel 
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libclutter-gtk3-devel librsvg-devel

%description
Lights Off is a puzzle game, where the objective is to turn off all of
the tiles on the board. Each click toggles the state of the clicked tile
and its non-diagonal neighbors.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%attr(-,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%_man6dir/%_name.6*

%changelog
