%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name quadrapassel
%define ver_major 40
%define xdg_name org.gnome.Quadrapassel

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1

Summary: A tetris clone
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Quadrapassel

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

Provides:  %_name = %version-%release

%define glib_ver 2.32.0
%define gtk_ver 3.12.0

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: librsvg-devel libclutter-gtk3-devel
BuildRequires: libmanette-devel libgsound-devel

%description
GNOME version of the popular russian game Tetris.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%attr(2711,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/scalable/apps/%{xdg_name}*.svg
%_iconsdir/hicolor/symbolic/apps/%{xdg_name}*.svg
%_man6dir/%_name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml


%changelog
