%define _unpackaged_files_terminate_build 1
%define ver_major 3.36
%define xdg_name org.gnome.Logs

%def_with man
%def_enable tests

Name: gnome-logs
Version: %ver_major.0
Release: alt1

Summary: The GNOME logfile viewer
Group: Graphical desktop/GNOME
License: GPL-3.0
Url: https://wiki.gnome.org/Apps/Logs

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

#Obsoletes: gnome-system-log < 3.11
#Provides: gnome-system-log = %version-%release

Requires: gsettings-desktop-schemas

%define glib_ver 2.44
%define gtk_ver 3.22

BuildRequires(pre): meson
BuildRequires: rpm-build-gnome gnome-common libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: gsettings-desktop-schemas-devel libsystemd-journal-devel
BuildRequires: libappstream-glib-devel yelp-tools desktop-file-utils
%{?_with_man:BuildRequires: docbook-dtds docbook-style-xsl xsltproc}

%description
GNOME Logs is a log viewer for the systemd journal.

%prep
%setup

%build
%meson %{?_with_man:-Dman=true} \
	%{?_enable_tests:-Dtests=true}

%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS README

%changelog
