%define ver_major 40
%define beta %nil
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Maps

Name: gnome-maps
Version: %ver_major.5
Release: alt1%beta

Summary: Maps is a map application for GNOME
License: GPL-2.0 and LGPL-2.0
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Maps

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

%set_typelibdir %_libdir/%name/girepository-1.0

%define glib_ver 2.44
%define gjs_ver 1.66
%define geocode_ver 3.20.0
%define geoclue_ver 2.4.0
%define champlain_ver 0.12.19

Requires: geoclue2 >= %geoclue_ver
Requires: libgeocode-glib-gir >= %geocode_ver
Requires: libchamplain-gir >= %champlain_ver

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Champlain)
Requires: typelib(Clutter)
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Geoclue)
Requires: typelib(GeocodeGlib)
Requires: typelib(GFBGraph)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeMaps)
Requires: typelib(Goa)
Requires: typelib(GObject)
Requires: typelib(Gtk) = 3.0
Requires: typelib(GtkChamplain)
Requires: typelib(GtkClutter)
Requires: typelib(GWeather)
Requires: typelib(Handy) = 1
Requires: typelib(Pango)
Requires: typelib(PangoCairo)
Requires: typelib(Rest)
Requires: typelib(Secret)
Requires: typelib(Soup) = 2.4
Requires: typelib(WebKit2) = 4.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgjs-devel >= %gjs_ver gobject-introspection-devel
BuildRequires: pkgconfig(geoclue-2.0) >= %geoclue_ver
BuildRequires: libgee0.8-devel libfolks-devel libgeocode-glib-devel libchamplain-gtk3-devel
BuildRequires: libgeocode-glib-gir-devel libchamplain-gtk3-gir-devel librest-gir-devel
BuildRequires: libclutter-gir-devel libcogl-gir-devel
BuildRequires: pkgconfig(libhandy-1)

%description
Maps is a map application for GNOME.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libdir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/symbolic/apps/%{xdg_name}*.svg
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README NEWS

%exclude %_libdir/%name/*.so
%exclude %_datadir/%name/gir-1.0/GnomeMaps-%api_ver.gir

%changelog
