%def_disable snapshot

%define ver_major 40
%define beta %nil
%define xdg_name org.gnome.Music
%define gst_api_ver 1.0

Name: gnome-music
Version: %ver_major.1.1
Release: alt1%beta

Summary: Music playing application for GNOME3
Group: Sound
License: GPLv2+
Url: http://wiki.gnome.org/Apps/Music

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

# use python3
AutoReqProv: nopython
%define __python %nil
%add_typelib_req_skiplist typelib(Gd) typelib(Gfm)

%define tracker_ver 3.0
%define gtk_ver 3.24.7
%define grilo_ver 0.3.13
%define python_ver 3.3
%define mediaart_ver 1.9
%define pygobject_ver 3.36.1
%define pycairo_ver 1.14.0
%define goa_ver 3.35.90

Requires: tracker-miners3 >= %tracker_ver typelib(Tracker) = 3.0
Requires: grilo-tools >= %grilo_ver grilo-plugins
Requires: gst-plugins-base%gst_api_ver

# gir-python.req doesn't recognize multiline expressions (see gnomemusic/albumartcache.py)
Requires: typelib(MediaArt) = 2.0 typelib(GstTag)

# gnomemusic/widgets/songwidget.py:from gi.repository.Dazzle import BoldingLabel  # noqa: F401
Requires: typelib(Dazzle)

%add_python3_req_skip gi.repository.Dazzle gi.repository.Gd

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: %_bindir/git
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= %gtk_ver libdazzle-devel libsoup-devel
BuildRequires: libgrilo-devel >= %grilo_ver grilo-plugins-devel
BuildRequires: libmediaart2.0-devel >= %mediaart_ver
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: python3-devel >= %python_ver
BuildRequires: pkgconfig(tracker-sparql-3.0) >= %tracker_ver
BuildRequires: python3-module-pygobject3-devel >= %pygobject_ver python3-module-pycairo-devel >= %pycairo_ver
BuildRequires: libgnome-online-accounts-devel >= %goa_ver

%description
Music playing application for GNOME3.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %xdg_name

%files -f %name.lang
%_bindir/%name
%_datadir/%xdg_name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/org.gnome.Music.gschema.xml
%_iconsdir/hicolor/*/*/*.svg
%_libdir/%xdg_name/
%python3_sitelibdir_noarch/gnomemusic/
%_datadir/metainfo/%xdg_name.appdata.xml
#%_man1dir/%name.1.*
%doc README* NEWS*

%changelog
