%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define xdg_name org.gnome.Photos
%define ver_major 40
%define _libexecdir %_prefix/libexec
%define gegl_api_ver 0.4
%define tracker_api_ver 3.0

%def_disable check

Name: gnome-photos
Version: %ver_major.0
Release: alt1.1

Summary: Photos - access, organize and share your photos on GNOME
License: GPL-2.0-or-later
Group: Graphics
Url: https://wiki.gnome.org/Apps/Photos

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.58
%define gtk_ver 3.22.16
%define tracker_ver 3.0
%define gdata_ver 0.15.2
%define gegl_ver 0.4.2
%define grilo_ver 0.3.5
%define png_ver 1.6
%define gfbgraph_ver 0.2.4
%define dazzle_ver 3.28
%define gexiv2_ver 0.12.1
%define handy_ver 1.1.90

Requires: grilo-plugins >= %grilo_ver

BuildRequires(pre): meson rpm-build-gnome
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(tracker-sparql-%tracker_api_ver) >= %tracker_ver
BuildRequires: libgdata-devel >= %gdata_ver
BuildRequires: libgegl-devel >= %gegl_ver
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libpng-devel >= %png_ver
BuildRequires: libgexiv2-devel >= %gexiv2_ver
BuildRequires: libexempi-devel liblcms2-devel librsvg-devel
BuildRequires: libjpeg-devel libgfbgraph-devel >= %gfbgraph_ver
BuildRequires: libgnome-desktop3-devel libgnome-online-accounts-devel zlib-devel
BuildRequires: libgeocode-glib-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libdazzle-devel > %dazzle_ver
BuildRequires: libdbus-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
%{?_enable_check:BuildRequires: dbus dogtail3}

%description
Photos, like Documents, Music and Videos, is one of the core GNOME
applications meant for find and reminding the user about her content.
The internal architecture Photos is based on Documents -- the document
manager application for GNOME, because they share similar UI/UX
patterns and objectives.

%prep
%setup

%build
%meson -Dbuildtype=plain
%meson_build

%install
%meson_install
rm -rf %buildroot/%_datadir/doc/%name
%find_lang --with-gnome %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_bindir/%name
%dir %_libdir/%name
%_libdir/%name/*.so
%_libexecdir/gnome-photos-thumbnailer
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/org.gnome.photos.gschema.xml
%doc ARTISTS AUTHORS NEWS README

%changelog
