%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 40
%define api_ver 1.0
%define xdg_name org.gnome.Todo

#disabled by default
%def_disable todo_txt_plugin
%def_disable todoist_plugin
%def_disable gtk_doc

Name: gnome-todo
Version: %ver_major.1
Release: alt1.1

Summary: Todo manager for GNOME
Group: Graphical desktop/GNOME
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Todo

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: gnome-todo-40.1-alt-build.patch

%define gtk_ver 4.2.1
%define libadwaita_ver 1.1.0
%define eds_ver 3.18.0

%add_python3_path %_libdir/%name/plugins
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
# no python3 plugins now
#Requires: libpeas-python3-loader

BuildRequires(pre): meson rpm-build-gir
BuildRequires: yelp-tools libappstream-glib-devel gtk-doc
BuildRequires: libgtk4-devel >= %gtk_ver libadwaita-devel >= %libadwaita_ver
BuildRequires: libpeas-devel
BuildRequires: evolution-data-server-devel >= %eds_ver libical-devel
BuildRequires: libgnome-online-accounts-devel 
BuildRequires: librest-devel libjson-glib-devel libportal-devel
BuildRequires: gir(Gtk) = 3.0 libadwaita-gir-devel

%description
GNOME Todo is a simple task management application designed to integrate
with GNOME.

%package devel
Summary: Development files for GNOME Todo
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package provides files necessary to develop plugins for GNOME Todo.

%package gir
Summary: GObject introspection data for the GNOME Todo
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GNOME Todo.

%package gir-devel
Summary: GObject introspection devel data for the GNOME Todo
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GNOME Todo.

%prep
%setup
%patch

%build
%meson %{?_enable_gtk_doc:-Ddocumentation=true} \
    %{?_enable_todo_txt_plugin:-Dtodo_txt_plugin=true} \
    %{?_enable_todoist_plugin:-Dtodoist_plugin=true}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.todo.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.todo.background.gschema.xml
%_iconsdir/hicolor/*/*/*.svg
%_datadir/metainfo/%xdg_name.*.xml
%doc NEWS README*

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc
%{?_enable_gtk_doc:%_datadir/gtk-doc/html/%name/}

%files gir
%_typelibdir/Gtd-%api_ver.typelib

%files gir-devel
%_girdir/Gtd-%api_ver.gir

%changelog
