Name: gnulib
Version: 0.1.4724.7e3a9
Release: alt1

Summary: GNU Portability Library
# assorted licenses, see the source
License: Freely distributable
Group: Development/C
BuildArch: noarch
Url: https://www.gnu.org/software/gnulib/
Source: %name-%version.tar
# git://git.altlinux.org/people/ldv/packages/gnulib refs/heads/po-current
Source1: po-%version-%release.tar
Patch1: gnulib-alt-utimens.patch
Patch2: gnulib-alt-mktime-internal.patch
AutoReqProv: no
BuildRequires: gnu-config makeinfo

%description
Gnulib is intended to be the canonical source for most of the important
"portability" and/or common files for GNU projects.  These are files
intended to be shared at the source level; Gnulib is not a typical
library meant to be installed and linked against.  Thus, unlike most
projects, Gnulib does not normally generate a source tarball
distribution; instead, developers grab modules directly from the
source repository.

%prep
%setup -a1
%patch1 -p1
%patch2 -p1

install -pm755 %_datadir/gnu-config/config.{guess,sub} build-aux/

%build
# Generate LINGUAS file.
ls build-aux/po/*.po | sed 's|.*/||; s|\.po$||' > build-aux/po/LINGUAS

make info

%install
rm -rf build-check
mkdir -p %buildroot{%_bindir,%_infodir,%_datadir/%name}
cp -a * %buildroot%_datadir/%name/
for f in check-module gnulib-tool; do
	ln -s $(relative %_datadir/%name/$f %_bindir/) %buildroot%_bindir/
done
mv %buildroot%_datadir/%name/doc/*.info %buildroot%_infodir/

%check
./gnulib-tool --create-testdir --dir build-check regex
cd build-check
%add_optflags -DDEBUG
%configure
%make_build -k check VERBOSE=1

%files
%_bindir/*
%_infodir/*
%_datadir/%name/

%changelog
