Summary: Exploring Conway's Game of Life and other cellular automata
Name: golly
Version: 3.1
Release: alt1

License: GPL
Url: http://golly.sourceforge.net/
Source: %name-%version-src.tar.gz
Source1: %name.sh
Source2: %name.desktop
Group: Education

%add_python_req_skip glife golly

Patch: golly-2.8-nolua.patch

# Automatically added by buildreq on Thu Mar 16 2017
# optimized out: fontconfig libGL-devel libX11-devel libgdk-pixbuf libstdc++-devel libwayland-client libwayland-server perl python-base python-modules xorg-xproto-devel
BuildRequires: ImageMagick-tools gcc-c++ libGLU-devel libwxGTK-devel lua-devel python-devel zlib-devel

BuildRequires: perl-Math-BigInt

Requires: %name-data = %EVR

%description
Welcome to Golly, a sophisticated tool for exploring Conway's
Game of Life and other cellular automata.

- Unbounded universe (limited only by memory).
- Fast, memory-efficient conventional algorithm.
- Use hashing to see large patterns evolve at huge time scales.
- Responsive even while generating or garbage collecting.
- Reads RLE, Life 1.05/1.06, dblife, and macrocell formats.
- Can also read common graphic formats: BMP, PNG, GIF, TIFF.
- Includes a state-of-the-art pattern collection.
- Supports other Life-like rules and Wolfram's 1D rules.
- Fast loading of large patterns.
- Paste in patterns from the clipboard.
- Unlimited undo/redo.
- Unbounded zooming out for astronomical patterns.
- Auto fit option keeps a generating pattern within view.
- Full screen option (no menu/status/tool/scroll bars).
- Supports multiple layers, including cloned layers.
- HTML-based help with integrated Life Lexicon.
- Scriptable via Perl or Python.
- User-configurable keyboard shortcuts.
- Free, open source and cross-platform (Windows, Mac, Linux).
- We also provide bgolly, a GUI-less version.

%package data
Summary: Data files for %name, cellular automata emulation software
BuildArch: noarch
Group: Education
%description data
%summary

%prep
%setup -n %name-%version-src
%patch -p1
sed -i 's/NEEDED +libperl\[/NEEDED +libperl[-/' gui-wx/configure/configure

%build
cd gui-wx
sed -i '/#include <EXTERN.h>/a\
#define PERL_GLOBAL_STRUCT
' wxperl.cpp
cd configure
%autoreconf
%configure --with-perl-shlib=%_libdir/perl5/CORE/libperl.so
%make_build

cd ..
for N in 16 32 48; do convert icons/appicon$N.ico $N.png; done

%install
cd gui-wx/configure
%makeinstall
cd ..
for N in 16 32 48; do
  install -D $N.png %buildroot%_iconsdir/hicolor/${N}x$N/apps/%name.png
done

install -D %SOURCE2 %buildroot%_desktopdir/%name.desktop

%files
%exclude %_datadir/doc/%name
%doc docs/*
%_bindir/*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/*

%files data
%_datadir/%name

%changelog
