Name: gossip
Version: 0.32
Release: alt4.git20090422.1

%def_enable dbus
%def_enable libnotify
%def_disable galago
%def_enable gnome_keyring
%def_disable ebook
%def_enable aspell
%def_disable peekaboo

Summary: Jabber client for GNOME
Group: Networking/Instant messaging
License: GPL
URL: http://developer.imendio.com/projects/gossip/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%define intltool_version 0.35.0
%define loudmouth_version 1.4.1
%define libxml2_version 2.6.16
%define glib_version 2.12.0
%define gtk_version 2.14.0
%define gio_version 2.16.0
%define gconf_version 1.2.0
%define panel_version 2.10.0
%define dbus_version 0.61
%define galago_version 0.5.0
%define libnotify_version 0.4.1
%define libglade_version 2.0.0
%define libgnome_version 2.0.0
%define libcanberra_version 0.3

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

# For macros
BuildPreReq: GConf librarian

# from configure.in
BuildPreReq: intltool >= %intltool_version
BuildPreReq: desktop-file-utils >= 0.2.90
BuildPreReq: libloudmouth-devel >= %loudmouth_version
BuildPreReq: libxml2-devel >= %libxml2_version
BuildPreReq: glib2-devel >= %glib_version
BuildPreReq: libgtk+2-devel >= %gtk_version
BuildPreReq: libGConf-devel >= %gconf_version
%{?_enable_peekaboo:BuildPreReq: libgnome-panel-devel >= %panel_version}
BuildPreReq: libglade-devel >= %libglade_version
BuildPreReq: iso-codes-devel
BuildPreReq: libgio-devel >= %gio_version
BuildPreReq: libcanberra-devel >= %libcanberra_version libcanberra-gtk2-devel
BuildPreReq: libXScrnSaver-devel libXext-devel libX11-devel
%{?_enable_dbus:BuildPreReq: libdbus-devel >= %dbus_version libdbus-glib-devel}
%{?_enable_libnotify:BuildPreReq: libnotify-devel >= %libnotify_version}
%{?_enable_galago:BuildPreReq: libgalago-devel >= %galago_version}
%{?_enable_gnome_keyring:BuildPreReq: libgnome-keyring-devel}
%{?_enable_ebook:BuildPreReq: evolution-data-server-devel}
%{?_enable_aspell:BuildPreReq: libaspell-devel}

BuildRequires: gcc-c++ gnome-doc-utils

%description
Gossip is an instant messaging program for GNOME.
Gossip aims at making Instant Messaging with Jabber as easy as possible,
while giving users of the GNOME Desktop a user friendly way of keeping
in touch with their friends.

%package peekaboo
Summary: Peekaboo applet for Gossip
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description peekaboo
An applet to quickly show Gossip chat windows and some of the
more popular functions of Instant Messaging.

%prep
%setup -q

%patch0 -p1
rm -f COPYING
ln -s %_licensedir/GPL-2 COPYING
bzip2 -9k ChangeLog

%build
intltoolize --force
gnome-doc-prepare --copy --force
%autoreconf
%configure \
	%{subst_enable dbus} \
	%{subst_enable libnotify} \
	%{subst_enable galago} \
	%{?_enable_gnome_keyring:--enable-gnome-keyring=yes} \
	%{subst_enable ebook} \
	--disable-schemas-install \
	--disable-scrollkeeper \
	--with-compile-warnings=yes
%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall %name
fi

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_datadir/applications/*
%_datadir/icons/hicolor/*/apps/*
%_datadir/sounds/*
%config(noreplace) %_sysconfdir/sound/events/gossip.soundlist
%config %_sysconfdir/gconf/schemas/*
%doc AUTHORS ChangeLog.bz2 NEWS README
%doc --no-dereference COPYING

%if_enabled dbus
%if_enabled peekaboo
%files peekaboo
%_libexecdir/peekaboo-applet
%_libdir/bonobo/servers/*
%endif
%endif

%changelog
