%global import_path github.com/grafana/grafana

%global _unpackaged_files_terminate_build 1
%define _runtimedir /run
%def_enable prebuilded_frontend

Name: grafana
Version: 12.1.0
Release: alt2
Summary: Metrics dashboard and graph editor

Group: Development/Other
License: AGPL-3.0-only AND Apache-2.0
Url: https://grafana.com

Source: %name-%version.tar
# Patch: %name-%version.patch

Source11: %name-cli
Source12: %name-server
Source13: %name-server.sysconfig
#Source14: %%name.logrotate
Source15: %name-server.init
Source16: %name-server.service
Source17: %name.tmpfiles

#ExclusiveArch: %%go_arches
# on ppc64le error:
# error Command failed with signal "SIGXCPU"
ExclusiveArch: x86_64 aarch64 loongarch64 mipsel riscv64
BuildRequires(pre): rpm-macros-golang rpm-macros-nodejs
BuildRequires: rpm-build-golang golang >= 1.24.4
%if_disabled prebuilded_frontend
BuildRequires: npm
BuildRequires: node >= 18 node-devel node-gyp
%endif
BuildRequires: fontconfig libfreetype
BuildRequires: /proc

%description
Grafana is an open source, feature rich metrics dashboard and graph editor
for Graphite, Elasticsearch, OpenTSDB, Prometheus and InfluxDB.

%prep
# Build the Front-end Assets
# $ node .yarn/releases/yarn-X.X.X.cjs install
# $ git add .yarn -f
# $ git commit -n --no-post-rewrite -m "add node js modules"

# Test build
# $ export NODE_OPTIONS="--max-old-space-size=8192" # Increase to 8 GB
# $ node .yarn/releases/yarn-X.X.X.cjs run build
#
# Go vendors modules
# $ go mod vendor -v
# $ git add -f vendor
# $ git commit -n --no-post-rewrite -m "update go modules by go mod vendor"

%setup
# %patch -p1

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export npm_config_devdir="$PWD/node_modules/.node-gyp"
export VERSION=%version
export COMMIT=%release
export BRANCH=altlinux

#%%golang_prepare
#cd .gopath/src/%%import_path
mkdir -p $BUILDDIR/src/github.com/grafana
ln -s %_builddir/%name-%version \
    $BUILDDIR/src/%import_path

pushd $BUILDDIR/src/%import_path

%if_disabled prebuilded_frontend

%ifarch %arm %ix86 %mips32 %mipsn32
export NODE_OPTIONS=--max_old_space_size=2048
%endif
#npm rebuild
#npm run build
#go run build.go build-frontend
node .yarn/releases/yarn-4.4.0.cjs run build
node .yarn/releases/yarn-4.4.0.cjs run plugins:build-bundled
%endif

# generate code from .cue files
go generate ./kinds/gen.go
go generate ./public/app/plugins/gen.go

# generate go files
go run ./pkg/build/wire/cmd/wire/main.go gen -tags oss ./pkg/server

#GO111MODULE=off CGO_ENABLED=1 go run build.go build
#%%golang_build pkg/cmd/*

CGO_ENABLED=1 go install -ldflags " -s -w  \
    -X main.version=$VERSION \
    -X main.commit=$COMMIT \
    -X main.buildBranch=$BRANCH \
    " -a ./pkg/cmd/grafana

popd

%install
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path:$PWD"
export GOFLAGS="-mod=vendor"

pushd $BUILDDIR/src/%import_path
# Install Front-end Assets
install -d -m 755 %buildroot%_datadir/%name
cp -pr conf %buildroot%_datadir/%name/
cp -pr public %buildroot%_datadir/%name/
%golang_install
popd

rm -rf -- %buildroot/usr/src
rm -f -- %buildroot%_bindir/govendor
rm -f -- %buildroot%_bindir/release_publisher
rm -f -- %buildroot%_bindir/slow_proxy
#TODO: package alert_webhook_listener
rm -f -- %buildroot%_bindir/alert_webhook_listener

# Install wrappers
install -p -m 755 %SOURCE11 %buildroot%_bindir/%name-cli
install -p -m 755 %SOURCE12 %buildroot%_bindir/%name-server

# Install config files
install -p -D -m 640 conf/sample.ini %buildroot%_sysconfdir/%name/%name.ini
install -p -D -m 640 conf/ldap.toml %buildroot%_sysconfdir/%name/ldap.toml
install -p -D -m 640 conf/provisioning/access-control/sample.yaml %buildroot%_sysconfdir/%name/provisioning/access-control/sample.yaml
install -p -D -m 640 conf/provisioning/alerting/sample.yaml %buildroot%_sysconfdir/%name/provisioning/alerting/sample.yaml
install -p -D -m 640 conf/provisioning/dashboards/sample.yaml %buildroot%_sysconfdir/%name/provisioning/dashboards/sample.yaml
install -p -D -m 640 conf/provisioning/datasources/sample.yaml %buildroot%_sysconfdir/%name/provisioning/datasources/sample.yaml
install -p -D -m 640 conf/provisioning/plugins/sample.yaml %buildroot%_sysconfdir/%name/provisioning/plugins/sample.yaml

# Setup directories
install -d -m 755 %buildroot%_logdir/%name
install -d -m 750 %buildroot%_sharedstatedir/%name
install -d -m 755 %buildroot%_sharedstatedir/%name/plugins
# Install pid directory
install -d -m 775 %buildroot%_runtimedir/%name
# Install sysconfig
install -p -D -m 644 %SOURCE13 %buildroot%_sysconfdir/sysconfig/%name-server
# Install logrotate
#install -p -D -m 644 %%SOURCE14 %%buildroot%%_logrotatedir/%%name
# Install sysv init scripts
install -p -D -m 755 %SOURCE15 %buildroot%_initdir/%name-server
# Install systemd unit services
install -p -D -m 644 %SOURCE16 %buildroot%_unitdir/%name-server.service
install -p -D -m 644 %SOURCE17 %buildroot%_tmpfilesdir/%name.conf

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -g %name -G %name -c 'Grafana Daemon' \
    -s /sbin/nologin  -d %_sharedstatedir/%name %name 2>/dev/null ||:

%post
%post_service %name-server
# create grafana.db with secure permissions on new installations
# otherwise grafana-server is creating grafana.db on first start
# with world-readable permissions, which may leak encrypted datasource
# passwords to all users (if the secret_key in grafana.ini was not changed)
if [ "$1" = 1 ] && [ ! -f %_sharedstatedir/%name/grafana.db ]; then
    touch %_sharedstatedir/%name/grafana.db
fi

# apply secure permissions to grafana.db if it exists
# (may not exist on upgrades, because users can choose between sqlite/mysql/postgres)
if [ -f %_sharedstatedir/%name/grafana.db ]; then
    chown %name:%name %_sharedstatedir/%name/grafana.db
    chmod 640 %_sharedstatedir/%name/grafana.db
fi

%preun
%preun_service %name-server
%files
%doc CHANGELOG.md LICENSE README.md
%_bindir/%name
%_bindir/%name-cli
%_bindir/%name-server
%config(noreplace) %_sysconfdir/sysconfig/%name-server
%_initdir/%name-server
%_unitdir/%name-server.service
%_tmpfilesdir/%name.conf
%dir %attr(0750, root, %name) %_sysconfdir/%name
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/access-control
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/alerting
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/dashboards
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/datasources
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/plugins
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/%name.ini
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/ldap.toml
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/provisioning/*/*.yaml
#%%config(noreplace) %%_logrotatedir/%%name
%dir %attr(0775, root, %name) %_logdir/%name
%dir %attr(0750, %name, %name) %_sharedstatedir/%name
%dir %attr(0755, %name, %name) %dir %_sharedstatedir/%name/plugins
%_datadir/%name

%changelog
