%def_disable snapshot

%define ver_major 0.3
%define api_ver %ver_major
%define gupnp_api_ver 1.2

%def_enable lua_factory
%def_enable tracker3

Name: grilo-plugins
Version: %ver_major.13
Release: alt1

Summary: Plugins for the Grilo framework
Group: Sound
License: LGPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/Grilo

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define tracker3_ver 2.99.2

Requires: grilo-tools >= %version
Requires: tracker3 >= %tracker3_ver

BuildRequires(pre): meson
BuildRequires: gperf
BuildRequires: gtk-doc yelp-tools
BuildRequires: libgio-devel >= 2.44
BuildRequires: libgrilo-devel >= %ver_major.13
BuildRequires: libxml2-devel
BuildRequires: libgupnp%gupnp_api_ver-devel >= 0.13
BuildRequires: libgssdp%gupnp_api_ver-devel
BuildRequires: libgupnp-av-devel >= 0.5
BuildRequires: libsqlite3-devel
BuildRequires: libgdata-devel >= 0.9.1
BuildRequires: libgom-devel >= 0.3.2
BuildRequires: libsoup-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgmime3.0-devel
%{?_enable_tracker3:BuildRequires: pkgconfig(tracker-sparql-3.0) >= %tracker3_ver tracker3-tests}
BuildRequires: liboauth-devel
BuildRequires: libgnome-online-accounts-devel >= 3.18.0
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: pkgconfig(libdmapsharing-3.0) >= 2.9.12
#BuildRequires: pkgconfig(libdmapsharing-4.0) >= 3.9.9
BuildRequires: libjson-glib-devel
BuildRequires: libavahi-gobject-devel libavahi-glib-devel libavahi-devel
BuildRequires: libmediaart2.0-devel
BuildRequires: librest-devel
BuildRequires: libarchive-devel
%{?_enable_lua_factory:BuildRequires: lua-devel >= 5.3}

%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains plugins to get information from theses sources:
- Apple Trailers
- Bookmarks
- Filesystem
- Flickr
- Gravatar
- Jamendo
- Last.fm (for album arts)
- Local metadata (album arts and thumbnails)
- Metadata Store
- Podcasts
- Shoutcast
- Tracker
- UPnP
- Vimeo
- Youtube

%package devel
Summary: Development files for Grilo flaugins
Group: Development/Other
Requires: %name = %version-%release

%description devel
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.

This package contains the pkg-config file for Grilo plugins package.

%prep
%setup

%build
%meson %{?_enable_lua_factory:-Denable-lua-factory=yes} \
%{?_disable_tracker:-Dtracker=no} \
%{?_disable_tracker3:-Dtracker3=no}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name examples

%files -f %name.lang
%dir %_libdir/grilo-%ver_major
%_libdir/grilo-%ver_major/libgrlbookmarks.so
%_libdir/grilo-%ver_major/libgrlchromaprint.so
%_libdir/grilo-%ver_major/libgrldaap.so
%_libdir/grilo-%ver_major/libgrldleyna.so
%_libdir/grilo-%ver_major/libgrldpap.so
%_libdir/grilo-%ver_major/libgrlfilesystem.so
%_libdir/grilo-%ver_major/libgrlflickr.so
%_libdir/grilo-%ver_major/libgrlfreebox.so
%_libdir/grilo-%ver_major/libgrlgravatar.so
%_libdir/grilo-%ver_major/libgrllocalmetadata.so
%{?_enable_lua_factory:%_libdir/grilo-%ver_major/libgrlluafactory.so}
%_libdir/grilo-%ver_major/libgrlmagnatune.so
%_libdir/grilo-%ver_major/libgrlmetadatastore.so
%_libdir/grilo-%ver_major/libgrlopensubtitles.so
%_libdir/grilo-%ver_major/libgrlopticalmedia.so
%_libdir/grilo-%ver_major/libgrlpodcasts.so
%_libdir/grilo-%ver_major/libgrlraitv.so
%_libdir/grilo-%ver_major/libgrlshoutcast.so
%_libdir/grilo-%ver_major/libgrlthetvdb.so
%_libdir/grilo-%ver_major/libgrltmdb.so
%{?_enable_tracker3:%_libdir/grilo-%ver_major/libgrltracker3.so}
%_libdir/grilo-%ver_major/libgrlyoutube.so
%if_enabled lua_factory
%dir %_datadir/%name
%_datadir/%name/grl-lua-factory/
%endif
%doc AUTHORS NEWS README*

%files devel
%_pkgconfigdir/%name-%api_ver.pc


%changelog
