%define _name gst-plugins
%define ver_major 1.20
%define api_ver 1.0

%define _gst_datadir %_datadir/gstreamer-%api_ver
%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable jack
%def_enable pulse
%def_enable qt5

%def_disable doc
%def_disable debug
%def_disable examples
%ifarch %ix86 x86_64 aarch64
%def_enable valgrind
%endif
%def_disable check

Name: %_name-good%api_ver
Version: %ver_major.7
Release: alt2

Summary: A set of GStreamer plugins considered good
Group: System/Libraries
License: LGPLv2+
Url: http://gstreamer.freedesktop.org/

Source: http://gstreamer.freedesktop.org/src/%_name-good/%_name-good-%version.tar.xz
# CVE-2024-47537
# https://gstreamer.freedesktop.org/security/sa-2024-0005.html
# CVE-2024-47539
# https://gstreamer.freedesktop.org/security/sa-2024-0007.html
# patch based on https://gitlab.freedesktop.org/gstreamer/gstreamer/-/merge_requests/8059.patch
Patch10: gst-plugins-good-1.20.7-alt-CVE-2024-47537-CVE-2024-47539.patch
# CVE-2024-47606
# https://gstreamer.freedesktop.org/security/sa-2024-0014.html
Patch11: https://gitlab.freedesktop.org/gstreamer/gstreamer/-/commit/f8e398c46fc074f266edb3f20479c0ca31b52448.patch
# CVE-2024-47613
# https://gstreamer.freedesktop.org/security/sa-2024-0025.html
Patch12: https://gitlab.freedesktop.org/gstreamer/gstreamer/-/merge_requests/8041.patch

Provides: %_name-good = %version-%release

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ orc nasm liborc-devel
BuildRequires: bzlib-devel gst-plugins%api_ver-devel >= %version
BuildRequires: libSM-devel libXdamage-devel libXext-devel libXfixes-devel
BuildRequires: libXv-devel libavc1394-devel libcairo-devel libdv-devel libflac-devel libiec61883-devel libjpeg-devel
BuildRequires: libshout2-devel libsoup-devel libtag-devel libv4l-devel libwavpack-devel
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libpng-devel libcairo-gobject-devel libgudev-devel libspeex-devel zlib-devel libvpx-devel
BuildRequires: libmpg123-devel liblame-devel libtwolame-devel
BuildRequires: libgtk+3-devel
BuildRequires: liborc-test-devel
%{?_enable_valgrind:BuildRequires: valgrind-tool-devel}
%{?_enable_jack:BuildRequires: libjack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_qt5:BuildRequires: qt5-base-devel qt5-tools qt5-declarative-devel qt5-x11extras-devel qt5-wayland-devel}
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}
%{?_enable_check:BuildRequires: /proc gstreamer%api_ver %_bindir/gst-tester-%api_ver}

%description
GStreamer Good Plug-ins is is a set of plug-ins that the developers consider
to have good quality code, correct functionality, and their preferred license
(LGPL for the plug-in code, LGPL or LGPL-compatible for the supporting
library).

%package qt5
Summary: Qt5 plugin for GStreamer
Group: System/Libraries
Requires: gst-plugins-base%api_ver >= %version

%description qt5
This package contains Qt5 GL plugin for Gstreamer.


%package devel-doc
Summary: Development documentation for GStreamer Good plugins
Group: Development/Documentation
BuildArch: noarch
Provides: %_name-good-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for GStreamer Good Plugins

%prep
%setup -n %_name-good-%version
%patch10 -p1
%patch11 -p3
%patch12 -p3

%build
%meson \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_doc:-Ddoc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}
%nil
%meson_build

%install
%meson_install
%find_lang %_name-good-%api_ver

%check
%__meson_test

%files -f %_name-good-%api_ver.lang
%_gst_libdir/*.so
%{?_enable_qt5:%exclude %_gst_libdir/libgstqmlgl.so}
%_gst_datadir/*
%doc AUTHORS NEWS README* RELEASE

%if_enabled qt5
%files qt5
%_gst_libdir/libgstqmlgl.so
%endif

%if_enabled doc
%files devel-doc
%_gtk_docdir/*
%endif

%changelog
