%define _name ges
%define new_name gst-editing-services
%define ver_major 1.20
%define gst_api_ver 1.0
%define api_ver 1.0

%def_disable doc

Name: gstreamer-editing-services
Version: %ver_major.7
Release: alt1

Summary: GStreamer Editing Services (GES)
Group: System/Libraries
License: GPLv2+ and LGPLv2+
Url: http://cgit.freedesktop.org/gstreamer/gst-editing-services/

Source: http://gstreamer.freedesktop.org/src/%new_name/%new_name-%version.tar.xz

%define gst_ver %version

Requires: lib%_name = %EVR
Requires: gst-validate >= %gst_ver

Provides: %new_name = %EVR

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_path %_libdir/gst-validate-launcher/python

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson gcc-c++ flex
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver-devel
BuildRequires: libgst-devtools-devel libxml2-devel
BuildRequires: gobject-introspection-devel gst-plugins%gst_api_ver-gir-devel
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}

%description
This is a high-level library for facilitating the creation of audio/video
non-linear editors.

%package -n lib%_name
Summary: GStreamer Editing Services (GES) library
License: LGPLv2+
Group: System/Libraries

%description -n lib%_name
GStreamer Editing Services (GES) is a high-level library for facilitating
the creation of audio/video non-linear editors.

%package -n lib%_name-devel
Summary: Development files for %name
License: LGPLv2+
Group: Development/C
Requires: lib%_name = %EVR

%description -n lib%_name-devel
This package provides libraries and header files for developing
applications that use %name library.

%package -n lib%_name-devel-doc
Summary: GES development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%_name-devel < %version

%description -n lib%_name-devel-doc
This package contains documentation necessary to develop applications
that use GStreamer Editing Services library.

%package -n lib%_name-gir
Summary: GObject introspection data for the GES
Group: System/Libraries
Requires: lib%_name = %EVR

%description -n lib%_name-gir
GObject introspection data for the GStreamer Editing Services library.

%package -n lib%_name-gir-devel
Summary: GObject introspection devel data for the GES
Group: Development/Other
BuildArch: noarch
Requires: lib%_name-gir = %EVR
Requires: lib%_name-devel = %EVR

%description -n lib%_name-gir-devel
GObject introspection devel data for the GStreamer Editing Services
library.

%prep
%setup -n %new_name-%version

%build
%meson %{?_enable_doc:-Ddoc=disabled}
%meson_build

%install
%meson_install

%files
%_bindir/%_name-launch-%api_ver
%_datadir/gstreamer-%gst_api_ver/validate/scenarios/*.scenario
%_libdir/gstreamer-%gst_api_ver/libgstges.so
%_libdir/gstreamer-%gst_api_ver/libgstnle.so
#%_datadir/bash-completion/completions/%_name-launch-%api_ver
%_man1dir/%_name-launch-*
# gi overrides
%python3_sitelibdir/gi/overrides/*
%doc ChangeLog README* RELEASE NEWS AUTHORS

# for tests only?
%exclude %_libdir/gst-validate-launcher/python/*

%files -n lib%_name
%_libdir/lib%_name-%api_ver.so.*

%files -n lib%_name-devel
%_includedir/gstreamer-%gst_api_ver/%_name/
%_libdir/*.so
%_pkgconfigdir/gst-editing-services-%api_ver.pc

%files -n lib%_name-gir
%_typelibdir/GES-%api_ver.typelib

%files -n lib%_name-gir-devel
%_girdir/GES-%api_ver.gir

%if_enabled doc
%files -n lib%_name-devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/
%endif

%changelog
