%def_disable static
%def_enable gtk_doc
%def_enable introspection

Name: gtkspell3
Version: 3.0.10
Release: alt1

Summary: On-the-fly spell checking for GtkTextView widgets, GTK+3 version
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://gtkspell.sourceforge.net/
# http://download.sourceforge.net/%name/%name-%version.tar.gz
# Source-git: git://git.code.sf.net/p/gtkspell/gtkspell
Source: %name-%version.tar


BuildRequires: gtk-doc intltool
BuildRequires: vala vala-tools libvala-devel
BuildRequires: gobject-introspection-devel
BuildRequires: gir(GObject) = 2.0 gir(GLib) = 2.0 gir(Gtk) = 3.0
BuildRequires: pkgconfig(glib-2.0) pkgconfig(gtk+-3.0) pkgconfig(enchant-2) pkgconfig(iso-codes)

%description
This is the GTK+3 version of the library.

GtkSpell provides word-processor-style highlighting and replacement of
misspelled words in a GtkTextView widget as you type.  Right-clicking a
misspelled word pops up a menu of suggested replacements.

%package -n lib%name
Summary: On-the-fly spell checking for GtkTextView widgets, GTK+3 version
Group: System/Libraries

%description -n lib%name
This is the GTK+3 version of the library.

GtkSpell provides word-processor-style highlighting and replacement of
misspelled words in a GtkTextView widget as you type.  Right-clicking a
misspelled word pops up a menu of suggested replacements.

%package -n lib%name-devel
Summary: Development files needed to build applications with %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files for developing applications
which use GtkSpell.

%package -n lib%name-devel-static
Summary: Static library needed to build static applications with %name
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package provides files for developing statically linked
applications which use GtkSpell.

%package -n lib%name-devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
Contains developer documentation for %name.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library


%prep
%setup
sed -i 's,GTK_SPELL_CFLAGS,GTK_SPELL3_CFLAGS,' \
  gtkspell/Makefile.am

%build
%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}

%make_build

%install
%makeinstall_std
%find_lang %name

%files -n lib%name -f %name.lang
%_libdir/*.so.*
%doc AUTHORS ChangeLog README

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_datadir/vala/vapi/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

%changelog
