Name: hostinfo
Version: 2.2
Release: alt7

Summary: Utility for looking up hostnames and IP addresses
License: MIT
Group: System/Configuration/Networking
Url: http://www.jmknoble.net/software/hostinfo

# due to resolve(1).
Conflicts: net-tools < 0:1.60-alt10

BuildRequires: help2man

# %url/hostinfo-%version.tar.gz
Source: hostinfo-%version.tar
Source1: resolve.c
Source2: resolve.1.inc
Patch: hostinfo-2.2-alt-fixes.patch

%description
hostinfo is an utility for looking up hostnames and IP addresses.
It is a simple wrapper around gethostbyname(3) and gethostbyaddr(3);
thus, it uses a combination of the local system's "host database"
(/etc/hosts and/or NIS/NIS+) and the DNS resolver.

%prep
%setup
%patch -p1
install -pm644 %_sourcedir/{resolve.c,resolve.1.inc} .

%build
make OPTFLAGS='%optflags -D_GNU_SOURCE'
help2man -N -s1 -i hostinfo.1.inc ./hostinfo >hostinfo.1
gcc %optflags resolve.c -o resolve
help2man -N -s1 -i resolve.1.inc ./resolve >resolve.1

%install
%makeinstall_std prefix="%prefix"
install -pD -m644 hostinfo.1 %buildroot%_man1dir/hostinfo.1
install -pm755 resolve %buildroot%_bindir/
install -pm644 resolve.1 %buildroot%_man1dir/

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%check
[ 'localhost.localdomain' = "$(%buildroot%_bindir/hostinfo -n 127.0.0.1)" ]

%files
%_bindir/*
%_man1dir/*
%doc ChangeLog

%changelog
