# -*- mode: rpm-spec; coding: utf-8 -*-
%define realname icewm
# Choose markdown or asciidoc to generate manual html
%def_with markdown

Name: %realname
Version: 3.3.1
Release: alt1.p10.1
Epoch:3

Summary: X11 Window Manager
Group: Graphical desktop/Icewm
License: LGPLv2
Url: https://ice-wm.org
Packager: Dmitriy Khanzhin <jinn@altlinux.org>

%define _icewmdocdir %_datadir/doc/%realname-%version

Provides: %realname-githubmod = %version-%release
Provides: %realname-light = %version-%release
Requires: design-%realname >= 1.0-alt12
Obsoletes: %realname-githubmod < %version-%release
Obsoletes: %realname-light < %version-%release

Source0: %realname-%version.tar
Source2: %realname.menu-method
Source3: %realname-16.png
Source4: %realname-32.png
Source5: %realname-48.png
Source6: start%realname
Source7: IceWM.xpm
Source8: %realname.wmsession
Source9: README.ALT
Source11: restart
Source12: icewm-old-changelog.bz2

Patch0: %realname-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake

# Automatically added by buildreq on Sun Jun 27 2021
BuildRequires: cmake gcc-c++ imlib2-devel libSM-devel libXcomposite-devel
BuildRequires: libXdamage-devel libXft-devel libXinerama-devel libXpm-devel
BuildRequires: libXrandr-devel libalsa-devel libao-devel libfribidi-devel
BuildRequires: librsvg-devel libsndfile-devel perl-Pod-Usage perl-devel
%if_with markdown
BuildRequires: discount
%else
BuildRequires: asciidoctor
%endif

%description
 Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.
 This release is based on alternative source, based on a community fork
maintained on Github https://github.com/bbidulock/icewm

Recommends: iftop, mutt

%package themes
Summary: Extra themes for IceWM
Group: Graphical desktop/Icewm
BuildArch: noarch

Requires: design-%realname >= 1.0-alt12
Conflicts: design-%realname-themes <= 1.0-alt5

%description themes
Extra themes that included to IceWM distribution

%prep
%setup
%patch0 -p1
%ifarch armh
sed -i 's@-Wl,--as-needed @&-Wl,--allow-shlib-undefined@' src/CMakeLists.txt
%endif
%ifarch %e2k
# somehow works with GCC, but it's bad code from any point of view
sed -i 's/\? directory : "."/? (char*)directory : "."/' src/misc.cc
%endif

%build
%cmake	-DPREFIX=%_prefix \
	-DCFGDIR=%_sysconfdir/X11/%realname \
	-DLIBDIR=%_x11x11dir/%realname \
	-DDOCDIR=%_icewmdocdir \
	-DCONFIG_IMLIB2=on \
	-DCONFIG_LIBRSVG=on \
	-DCONFIG_GUIEVENTS=on \
	-DICESOUND="AO,ALSA,OSS" \
	-DENABLE_LTO=off \
	-DXTERMCMD=xvt \
	-DCONFIG_DEFAULT_THEME="AltClearlooks/default.theme" \
	-DCONFIG_DEFAULT_BACKGROUND="/usr/share/design/current/backgrounds/default.png" \
	-DICEHELPIDX=%_icewmdocdir/ru/icewm.html \
	-DUSE_DOC_LANG=ru
%cmake_build

%install
# This step seems to be necessary for some reason. Executables have to be
# relinked before installation into buildroot; cmake --install alone does not
# invoke the re-link step.
DESTDIR=%buildroot %cmake_build -t install
%cmake_install

mkdir -p %buildroot%_sysconfdir/menu-methods
install -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%realname

install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%realname.png
install -pD -m644 %SOURCE4 %buildroot%_niconsdir/%realname.png
install -pD -m644 %SOURCE5 %buildroot%_liconsdir/%realname.png
install -pD -m644 %SOURCE7 %buildroot%_pixmapsdir/IceWM.xpm
install -pD -m644 %SOURCE8 %buildroot%_sysconfdir/X11/wmsession.d/04IceWM
install -m644 %SOURCE9 README.ALT
install -m644 %SOURCE12 %buildroot%_icewmdocdir/icewm-old-changelog.bz2
install -m644 AUTHORS %buildroot%_icewmdocdir/AUTHORS
install -m644 NEWS %buildroot%_icewmdocdir/NEWS
install -m644 README.md %buildroot%_icewmdocdir/README.md

mkdir -p %buildroot%_sysconfdir/X11/%realname

install -m 755 %SOURCE6 %buildroot%_bindir/start%realname
install -m 755 %SOURCE11 %buildroot%_sysconfdir/X11/%realname/restart

%find_lang  %realname

# remove unpackaged files
rm -f %buildroot/%_bindir/%realname-set-gnomewm
rm -f %buildroot/%_datadir/xsessions/%realname.desktop

%files -f %realname.lang
%dir %_sysconfdir/X11/%realname
%config(noreplace) %_sysconfdir/X11/%realname/restart
%config(noreplace) %_sysconfdir/menu-methods/*
%_sysconfdir/X11/wmsession.d/*
%_bindir/*
%dir %_x11x11dir/%realname
%_x11x11dir/%realname/*
%exclude %_x11x11dir/%realname/themes/*
%_niconsdir/*
%_miconsdir/*
%_liconsdir/*
%_pixmapsdir/*
%_man1dir/*
%_man5dir/*
%_mandir/ru/*
%_datadir/xsessions/*.desktop
%dir %_icewmdocdir
%_icewmdocdir/*

%files themes
%_x11x11dir/%realname/themes/*

%changelog
