Name: id3lib
Version: 3.8.3
Release: alt10

Summary: A software library for manipulating ID3v1 and ID3v2 tags
License: LGPL
Group: System/Libraries
Url: http://id3lib.sourceforge.net
Packager: Repocop Q. A. Robot <repocop@altlinux.org>

Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.bz2
Patch1: %name-3.8.0-no_included_zlib.patch
Patch2: %name-3.8.2-doxygen.patch
Patch3: id3lib-3.8.3-libadd.patch
Patch4: id3lib-3.8.3-SA26536-fix.diff
Patch5: id3lib-3.8.3-gcc-4.3.patch
Patch6: id3lib-3.8.3-utf16.patch

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

# Automatically added by buildreq on Wed Dec 03 2003
BuildRequires: doxygen gcc-c++ libstdc++-devel zlib-devel

Summary(ru_RU.CP1251):      ID3v1  ID3v2

%description
This package provides a software library for manipulating ID3v1 and ID3v2 tags.
It provides a convenient interface for software developers to include
standards-compliant ID3v1/2 tagging capabilities in their applications.
Features include identification of valid tags, automatic size conversions,
(re)synchronisation of tag frames, seamless tag (de)compression, and optional
padding facilities.

%description -l ru_RU.CP1251
       ID3v1  ID3v2.
   , 
 ID3v1/2,     .
    ,  
,      () .

%package utils
Summary: A set of small applications that use the id3lib library.
Group: Sound
Requires: %name = %version-%release

%description utils
This package contains simple applications that make use of
id3lib, a software library for ID3v1 and ID3v2 tag manipulation.

%description utils -l ru_RU.CP1251
    ,   id3lib.

%package devel
Summary: Headers for developing programs that will use id3lib
Group: Development/C
PreReq: %name = %version-%release
Requires: libpopt-devel, libstdc++-devel, zlib-devel

%description devel
This package contains the headers and API documentation that programmers
will need to develop applications which will use id3lib, the software
library for ID3v1 and ID3v2 tag manipulation.

%description devel -l ru_RU.CP1251
        API ,
    id3lib   .

%package devel-static
Summary: Headers for developing programs that will use id3lib
Group: Development/C
PreReq: %name-devel = %version-%release

%description devel-static
This package contains development libraries required for packaging
statically linked software with id3lib.

%description devel-static -l ru_RU.CP1251
     , 
   ,  id3lib.

%prep
%setup -q
rm -rfv zlib
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p1
%patch6 -p1

%build
autoconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
export ac_cv_lib_z_uncompress=yes
%configure %{subst_enable static} 
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build
%make_build docs

gzip ChangeLog

%install
%makeinstall

%files
%_libdir/*.so.*
%doc AUTHORS ChangeLog.gz HISTORY NEWS README THANKS TODO

%files utils
%_bindir/*

%files devel
%_includedir/*
#_libdir/*.la
%_libdir/*.so
%doc doc/*.{html,png,jpg,gif,txt,ico,php,css} doc/api

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
