%define _libexecdir %_prefix/libexec

Name: inn
Version: 2.6.4
Release: alt1

Summary: The InterNetNews (INN) system, an Usenet news server
License: %gpl2plus
Group: System/Servers

Url: http://ftp.isc.org/isc/inn/

Source0: %name-%version.tar
Source1: %name-default-active
Source2: %name-default-distributions
Source3: %name-default-newsgroups
Source4: %name-cron-expire
Source5: %name-cron-rnews
Source6: %name-etc-nnrp.access
Source7: %name-cron-nntpsend
Source8: innd.init
Source9: innwatch.init
# ftp://ftp.exit109.com/users/jeremy/cleanfeed-latest.tar.bz2
#Source9: cleanfeed-latest.tar
# ftp://ftp.isc.org/pub/pgpcontrol/pgpverify-1.2.1
#Source10: pgpverify-1.2.1
#Source11: %name-faq.tar

Patch1: 0001-Fix-libstorage-linking.patch
Patch2: 0001-Fix-krb5-inclusion.patch
Patch3: 0001-inn-lib-date.c-remove-erroneous-include.patch
Patch4: big-alt-patch.patch
Patch5: inn-redhat_build.patch
Patch6: inn-2.5.2-pconf.patch
Patch7: inn-2.6.2-linelimit-1098.patch

BuildRequires(pre): rpm-build-licenses

Requires: lib%name = %version-%release

#post-install unowned files:
# /var/www
# /var/www/webapps
Requires: webserver-common

BuildRequires: ctags flex gnupg  su tcl time uucp wget gawk ncompress perl-podlators
BuildRequires: libkrb5-devel libpam-devel libssl-devel libsasl2-devel libdb4-devel libe2fs-devel
BuildRequires: perl-devel perl-libnet perl-Math-BigInt perl-Encode perl-MIME-tools perl-GD-Text
BuildRequires: python-devel python-modules-compiler python-modules-encodings

%description
INN (InterNetNews) is a complete system for serving Usenet news and/or
private newsfeeds.  INN includes innd, an NNTP (NetNews Transport
Protocol) server, and nnrpd, a newsreader that is spawned for each client.
Both innd and nnrpd vary slightly from the NNTP protocol, but not in ways
that are easily noticed.

Install the inn package if you need a complete system for serving and
reading Usenet news.  You may also need to install inn-devel, if you are
going to use a separate program which interfaces to INN, like newsgate or
tin.

!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!
!!! ATTENTION !!!                                                     !!! ATTENTION !!!
!!! ATTENTION !!!        THIS PACKAGE IS COMPLETELY INSECURE.         !!! ATTENTION !!!
!!! ATTENTION !!! DON'T INSTALL IT UNLESS YOU DON'T CARE OF SECURITY. !!! ATTENTION !!!
!!! ATTENTION !!!                                                     !!! ATTENTION !!!
!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!

%package -n lib%name-devel
Summary: The INN (InterNetNews) development header files and libraries
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
The inn-devel package contains the INN (InterNetNews) library, which
several programs that interface with INN need in order to work (for
example, newsgate and tin).

%package -n lib%name
Summary: The shared libraries required for inn server.
Group: System/Libraries

%description -n lib%name
The inn-libs package provides the essential shared libraries for inn server.
You will need to install this package to use inn package or any clients that
need to connect to a inn server.

%package -n inews
Summary: Sends Usenet articles to a local news server for distribution
Group: System/Servers
Requires: lib%name = %version-%release
Requires: %name

%description -n inews
The inews program is used by some news programs (for example, inn and
trn) to post Usenet news articles to local news servers.  Inews reads an
article from a file or standard input, adds headers, performs some
consistency checks and then sends the article to the local news server
specified in the inn.conf file.

Install inews if you need a program for posting Usenet articles to local
news servers.

%prep
%setup
%patch1 -p1
#patch2 -p2
#patch3 -p2
#patch4 -p2
%patch5 -p1
%patch6 -p1
%patch7 -p2

%build

# [hack]: fix path to -ldb
sed -i -e "s,@BERKELEY_DB_LDFLAGS@,-L%_libdir,g" Makefile.global.in
rm -f config.cache
autoconf
export CFLAGS="%optflags %optflags_shared"

./configure \
	--bindir=%_libexecdir/%name \
	--exec-prefix=%_libexecdir/%name \
	--with-control-dir=%_libexecdir/%name/control \
	--libdir=%_libdir \
	--mandir=%_mandir \
	--includedir=%_includedir \
	\
	--sysconfdir=%_sysconfdir/news \
	--with-filter-dir=%_sysconfdir/news/filter \
	\
	--with-log-dir=%_logdir/inn \
	--with-spool-dir=%_spooldir/news\
	--with-db-dir=%_localstatedir/news \
	--with-run-dir=%_var/run/news \
	--with-tmp-dir=%_var/run/news/tmp \
	\
	--with-doc-dir=%_docdir/%name-%version \
	--with-http-dir=%_var/www/webapps/%name \
	\
	--enable-shared --disable-static \
	--enable-largefiles \
	--enable-keywords \
	\
	--with-news-user=news --with-news-group=news --with-news-master=news \
	--with-sendmail=%_sbindir/sendmail \
	\
	--with-perl --with-libperl-dir=%perl_vendor_privlib \
	--with-python \
	\
	--with-openssl \
	--with-sasl \
	--with-bdb \
	--with-krb5 \
	#

# Removed bad RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

#NO SMP
%make

%install
%make install DESTDIR=%buildroot OWNER= ROWNER=

# -- Install man pages needed by suck et al.
#for f in clibrary.h config.h dbz.h libinn.h storage.h; do
#	install -pD -m644 ./include/$f "$RPM_BUILD_ROOT%_includedir/%name/$f"
#done

touch %buildroot%_localstatedir/news/subscriptions
chmod 644 %buildroot%_localstatedir/news/subscriptions

#install -m 644 $RPM_SOURCE_DIR/inn-default-active \
#        %buildroot%_localstatedir/news/active
install -m 644 $RPM_SOURCE_DIR/inn-default-distributions \
        %buildroot%_localstatedir/news/distributions
install -m 644 $RPM_SOURCE_DIR/inn-default-newsgroups \
        %buildroot%_localstatedir/news/newsgroups

mkdir -p %buildroot%_sysconfdir/cron.hourly %buildroot%_sysconfdir/cron.daily
sed "s|@@execprefix@@|%_libexecdir/%name|" < $RPM_SOURCE_DIR/inn-cron-expire > %buildroot%_sysconfdir/cron.daily/inn-cron-expire
chmod 755 %buildroot%_sysconfdir/cron.daily/inn-cron-expire
sed "s|@@execprefix@@|%_libexecdir/%name|" < $RPM_SOURCE_DIR/inn-cron-rnews > %buildroot%_sysconfdir/cron.hourly/inn-cron-rnews
chmod 755 %buildroot%_sysconfdir/cron.hourly/inn-cron-rnews
sed "s|@@execprefix@@|%_libexecdir/%name|" < $RPM_SOURCE_DIR/inn-cron-nntpsend > %buildroot%_sysconfdir/cron.hourly/inn-cron-nntpsend
chmod 755 %buildroot%_sysconfdir/cron.hourly/inn-cron-nntpsend

install -m440 $RPM_SOURCE_DIR/inn-etc-nnrp.access \
        %buildroot%_sysconfdir/news/nnrp.access

mkdir -p %buildroot%_initdir
sed "s|@@execprefix@@|%_libexecdir/%name|" < %SOURCE8 > %buildroot%_initdir/innd
sed "s|@@execprefix@@|%_libexecdir/%name|" < %SOURCE9 > %buildroot%_initdir/innwatch
chmod 755 %buildroot%_initdir/innd
chmod 755 %buildroot%_initdir/innwatch

# symlinks in %_bindir
mkdir -p %buildroot%_bindir
ln -sf %_libexecdir/%name/inews %buildroot%_bindir/inews
ln -sf %_libexecdir/%name/rnews %buildroot%_bindir/rnews

rm -f %buildroot%_localstatedir/news/history
touch %buildroot%_localstatedir/news/history
chmod 644 %buildroot%_localstatedir/news/*

#Fix perms in sample directory to avoid bogus dependencies
find samples -name "*.in" -exec chmod a-x {} \;

mkdir -p %buildroot%_spooldir/news/articles
mkdir -p %buildroot%_spooldir/news/overview
mkdir -p %buildroot%_spooldir/news/archive
mkdir -p %buildroot%_spooldir/news/incoming/bad
mkdir -p %buildroot%_spooldir/news/outgoing
mkdir -p %buildroot%_spooldir/news/uniover
mkdir -p %buildroot%_spooldir/news/innfeed
mkdir -p %buildroot%_logdir/inn
mkdir -p %buildroot%_var/run/news/tmp

#mkdir -p %buildroot%perl_vendor_privlib
mv %buildroot%_libexecdir/%name/innreport_inn.pm %buildroot%perl_vendor_privlib

%post
#if [ `%__cat %_sysconfdir/news/inn.conf | %__grep '^server:' | wc -l` -lt 1 ]; then
#  echo "server: `hostname -f`" >> %_sysconfdir/news/inn.conf
#fi

%post_service innd
%post_service innwatch

%preun
%preun_service innd
%preun_service innwatch
if [ -f %_localstatedir/news/history.dir ]; then
	rm -f %_localstatedir/news/history.*
fi

# fix default filter path change introduced in 2.4.5-alt3
%triggerun -- inn =< 2.4.5-alt3
if [ "$2" -eq 0 ]; then
	sed -i -e "s,\(^pathfilter:[ \t]*\)%_libdir/%name/filter,\1%_sysconfdir/news/filter," \
		%_sysconfdir/news/inn.conf
fi

%files
#doc samples README* ChangeLog CONTRIBUTORS LICENSE INSTALL NEWS TODO
#doc doc/checklist doc/config-design doc/config-semantics doc/config-syntax doc/external-auth
#doc doc/history doc/hook-perl doc/hook-python doc/IPv6-info doc/sample-control
%_docdir/%name-%version

%dir %attr(2770,root,news) %_spooldir/news
%dir %attr(2770,root,news) %_spooldir/news/articles
%dir %attr(2770,root,news) %_spooldir/news/overview
%dir %attr(2770,root,news) %_spooldir/news/archive
%dir %attr(2770,root,news) %_spooldir/news/incoming
%dir %attr(2770,root,news) %_spooldir/news/incoming/bad
%dir %attr(2770,root,news) %_spooldir/news/outgoing
%dir %attr(2770,root,news) %_spooldir/news/uniover
%dir %attr(2770,root,news) %_spooldir/news/innfeed
%dir %attr(2770,root,news) %_logdir/%name
%dir %attr(2770,root,news) %_var/run/news
%dir %attr(2770,root,news) %_var/run/news/tmp
%dir %attr(2770,root,news) %_localstatedir/news

%dir %attr(775,root,news)  %_var/www/webapps/%name
%_var/www/webapps/%name/innreport.css

%perl_vendor_privlib/INN
%perl_vendor_privlib/innreport_inn.pm

%attr(-,news,root) %config(noreplace) %_localstatedir/news/*
%attr(-,root,news) %dir %_sysconfdir/news
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/actsync.cfg
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/actsync.ign
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/buffindexed.conf
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/control.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/cycbuff.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/distrib.pats
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/expire.ctl
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/incoming.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/inn.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innfeed.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innreport.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innwatch.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/moderators
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/motd.innd.sample
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/motd.nnrpd.sample
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/news2mail.cf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/newsfeeds
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/nnrp.access
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/nnrpd.track
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/nntpsend.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/ovdb.conf
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/passwd.nntp
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/inn-radius.conf
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/readers.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/storage.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/subscriptions
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/control.ctl.local
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/distributions
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/localgroups
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/nocem.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/send-uucp.cf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innshellvars.local
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innshellvars.pl.local
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innshellvars.tcl.local

%_sysconfdir/cron.hourly/*
%_sysconfdir/cron.daily/*
%_sysconfdir/rc.d/init.d/*

%dir %attr(755,root,news) %_sysconfdir/news/filter
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/filter/*

%_man1dir/convdate.*
%_man1dir/fastrm.*
%_man1dir/getlist.*
%_man1dir/grephistory.*
%_man1dir/innconfval.*
%_man1dir/innmail.*
%_man1dir/nntpget.*
%_man1dir/rnews.*
%_man1dir/shlock.*
%_man1dir/shrinkfile.*
%_man1dir/simpleftp.*
%_man1dir/pgpverify.*
%_man1dir/sm.*
%_man1dir/pullnews.*

%_man5dir/*
%_man8dir/*

%dir %_libexecdir/%name

%attr(4510,root,news) %_libexecdir/%name/innbind
%attr(755,root,news) %_libexecdir/%name/rnews
%_bindir/rnews

%defattr(-,root,news)
%_libexecdir/%name/ovdb_init
%_libexecdir/%name/ovdb_monitor
%_libexecdir/%name/ovdb_server
%_libexecdir/%name/ovdb_stat
%_libexecdir/%name/perl-nocem
%_libexecdir/%name/tdx-util
%_libexecdir/%name/innupgrade
%_libexecdir/%name/ninpaths
%_libexecdir/%name/innd
%_libexecdir/%name/nnrpd
%_libexecdir/%name/innfeed
%_libexecdir/%name/procbatch
%_libexecdir/%name/convdate
%_libexecdir/%name/expire
%_libexecdir/%name/expireover
%_libexecdir/%name/expirerm
%_libexecdir/%name/fastrm
%_libexecdir/%name/grephistory
%_libexecdir/%name/makedbz
%_libexecdir/%name/makehistory
%_libexecdir/%name/prunehistory
%_libexecdir/%name/cnfsheadconf
%_libexecdir/%name/cnfsstat
%_libexecdir/%name/ctlinnd
%_libexecdir/%name/getlist
%_libexecdir/%name/innconfval
%_libexecdir/%name/mailpost
%_libexecdir/%name/pullnews
%_libexecdir/%name/scanspool
%_libexecdir/%name/signcontrol
%_libexecdir/%name/sm
%_libexecdir/%name/actmerge
%_libexecdir/%name/actsync
%_libexecdir/%name/actsyncd
%_libexecdir/%name/archive
%_libexecdir/%name/batcher
%_libexecdir/%name/buffchan
%_libexecdir/%name/controlbatch
%_libexecdir/%name/controlchan
%_libexecdir/%name/cvtbatch
%_libexecdir/%name/filechan
%_libexecdir/%name/inndf
%_libexecdir/%name/innxmit
%_libexecdir/%name/innxbatch
%_libexecdir/%name/mod-active
%_libexecdir/%name/news2mail
%_libexecdir/%name/nntpget
%_libexecdir/%name/nntpsend
%_libexecdir/%name/overchan
%_libexecdir/%name/pgpverify
%_libexecdir/%name/send-ihave
%_libexecdir/%name/send-nntp
%_libexecdir/%name/send-uucp
%_libexecdir/%name/sendxbatches
%_libexecdir/%name/shlock
%_libexecdir/%name/shrinkfile
%_libexecdir/%name/inncheck
%_libexecdir/%name/innmail
%_libexecdir/%name/innreport
%_libexecdir/%name/innstat
%_libexecdir/%name/innwatch
%_libexecdir/%name/news.daily
%_libexecdir/%name/scanlogs
%_libexecdir/%name/simpleftp
%_libexecdir/%name/tally.control
%_libexecdir/%name/writelog
%_libexecdir/%name/docheckgroups
%_libexecdir/%name/imapfeed
%_libexecdir/%name/sendinpaths
%_libexecdir/%name/buffindexed_d
%_libexecdir/%name/tinyleaf
%_libexecdir/%name/rc.news

%dir %_libexecdir/%name/auth

%dir %_libexecdir/%name/auth/passwd
%_libexecdir/%name/auth/passwd/auth_krb5
%_libexecdir/%name/auth/passwd/ckpasswd
%_libexecdir/%name/auth/passwd/radius

%dir %_libexecdir/%name/auth/resolv
%_libexecdir/%name/auth/resolv/domain
%_libexecdir/%name/auth/resolv/ident

%dir %_libexecdir/%name/control
%_libexecdir/%name/control/checkgroups.pl
%_libexecdir/%name/control/ihave.pl
%_libexecdir/%name/control/newgroup.pl
%_libexecdir/%name/control/rmgroup.pl
%_libexecdir/%name/control/sendme.pl
%_libexecdir/%name/control/sendsys.pl
%_libexecdir/%name/control/senduuname.pl
%_libexecdir/%name/control/version.pl

%dir %_libexecdir/%name/rnews.libexec
%_libexecdir/%name/rnews.libexec/bunbatch
%_libexecdir/%name/rnews.libexec/c7unbatch
%_libexecdir/%name/rnews.libexec/decode
%_libexecdir/%name/rnews.libexec/encode
%_libexecdir/%name/rnews.libexec/gunbatch

%_libexecdir/%name/innshellvars
%_libexecdir/%name/innshellvars.pl
%_libexecdir/%name/innshellvars.tcl

%files -n lib%name
%_libdir/libinn.so.*
%_libdir/libstorage.so.*
%_libdir/libinnhist.so.*

%files -n lib%name-devel
%_libdir/libinn.so
%_libdir/libstorage.so
%_libdir/libinnhist.so
%_includedir/%name
%_man3dir/*

%files -n inews
%_man1dir/inews*
%attr(755,root,news) %_libexecdir/%name/inews
%_bindir/inews

%changelog
