%define native iperf
%define abiversion 0

%define use_chrpath 1

Name: iperf3
Version: 3.19.1
Release: alt1

Summary: A TCP, UDP, and SCTP network bandwidth measurement tool
License: BSD-3-Clause and MIT
Group: Monitoring

Url: http://software.es.net/iperf
Source0: http://downloads.es.net/pub/iperf/%native-%version.tar.gz
Source1: iperf3.sysconfig
Source2: iperf3.init
Source3: iperf3.service

Requires: lib%name-%abiversion = %version-%release

%ifdef use_chrpath
BuildRequires: chrpath
%endif

%package -n lib%name-%abiversion
Summary: iperf shared library
Group: System/Libraries
Provides: lib%name = %version-%release

%package -n lib%name-devel
Summary: iperf's development files
Group: Development/C
Requires: lib%name-%abiversion = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description
iperf is a tool for active measurements of the maximum achievable
bandwidth on IP networks.  It supports tuning of various parameters
related to timing, protocols, and buffers.  For each test it reports
the bandwidth, loss, and other parameters.

This version, sometimes referred to as iperf3, is a redesign of an
original version developed at NLANR/DAST.  iperf3 is a new
implementation from scratch, with the goal of a smaller, simpler code
base, and a library version of the functionality that can be used in
other programs. iperf3 also a number of features found in other tools
such as nuttcp and netperf, but were missing from the original iperf.
These include, for example, a zero-copy mode and optional JSON output.

Note that iperf3 is NOT backwards compatible with the original iperf.

%description -n lib%name-%abiversion
Librairies for iperf3

%description -n lib%name-devel
This package contains development files of iperf3

%prep
%setup -q -n %native-%version

%build

# fixed RPATH issue
# https://lists.altlinux.org/pipermail/community/2014-October/682803.html
%ifndef use_chrpath
libtoolize --copy --force --automake
aclocal -I config
autoheader
automake --foreign --add-missing --copy
autoconf
%endif

%configure
%make_build

%install
%makeinstall

rm -f %buildroot/%_libdir/*.a

install -pDm0644 %SOURCE1 %buildroot/%_sysconfdir/sysconfig/%name

install -pDm0755 %SOURCE2 %buildroot/%_initdir/%name
install -pDm0644 %SOURCE3 %buildroot/%_unitdir/%name.service

# fixed RPATH issue
%ifdef use_chrpath
chrpath -d %buildroot/%_bindir/iperf3
%endif

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/*
%_mandir/man?/*
%_initdir/%name
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/sysconfig/%name
%doc LICENSE README.md RELNOTES.md

%files -n lib%name-%abiversion
/%_libdir/lib%native.so.*

%files -n lib%name-devel
%_includedir/%{native}_api.h
%_libdir/lib%native.so

%changelog
