%def_disable gimp
%define rel 2

Name: iscan-free
Version: 2.30.4
Release: alt2

Summary: Free Image Scan Version with epkowa Driver for Epson Scanners

Packager: Vitaly Lipatov <lav@altlinux.ru>

Url: http://support.epson.net/linux/src/scanner/iscan/
License: GPL v2 or later; LGPL v2.1 or later
Group: Graphics

# Note! Source tarball modified with .gear/postdownload-hoook script
# Source-url: http://support.epson.net/linux/src/scanner/iscan/iscan_%version-%rel.tar.gz
Source: %name-%version.tar
# A README regarding the changes of the free version:
Source1: README

Patch1: libltdl.patch
Patch2: iscan-i586-fix.patch
# Patch10 changes the "sane-epkowa" man page so that those models are removed
# which require a non-free binary-only i386-only plugin. To determine those models use
# egrep '^:model|^:comment' doc/epkowa.desc | grep -B1 'non-free' | grep '^:model'
Patch10: adapt-man-for-free.patch

# Either iscan-free or iscan can be installed.
# If iscan replaces iscan-free, proprietary software becomes installed.
# If iscan-free replaces iscan, some scanner models do no longer work (see README).
# Therefore real "Conflicts" (and not "Obsoletes" which does a silent replacement):
Conflicts: iscan

#BuildRequires: glibc-devel libappstream-glib-devel libdb4-devel libgtk+3-devel libpolkit-devel 
BuildRequires: gcc-c++ libgtk+2-devel libjpeg-devel libltdl7-devel libsane-devel libtiff-devel libusb-devel libxml2-devel
%if_enabled gimp
BuildRequires: libgimp-devel
%endif

# %_localstatedir
BuildRequires: rpm-macros-intro-conflicts

%description
mage Scan! is a graphical scanner utility for people that do not need
all the bells and whistles provided by several of the other utilities
out there (xsane, QuiteInsane, Kooka).

At the moment it only supports SEIKO EPSON scanners and all-in-ones.
However, the scanner driver it provides can be used by any other SANE
standard compliant scanner utility.

Note that several scanners require a non-free plugin before they can
be used with this software.

%prep
%setup
%patch2 -p1
%__subst "s|non-free||" Makefile*
#grep -q 'requires DFSG non-free' doc/epkowa.desc || exit 1
#__subst '/requires DFSG non-free/s/^:comment[[:space:]][[:space:]]*"/:comment "unsupported by the iscan-free package<br>/' doc/epkowa.desc
#__subst 's/requires DFSG non-free/requires DFSG non-free plugin in the iscan-proprietary-drivers package:/' doc/epkowa.desc

%build
# won't fix stalled upstream
%add_optflags -fcommon
%configure \
            -enable-dependency-reduction \
            --enable-jpeg \
            --enable-png \
            %{subst_enable gimp} \
            --enable-tiff \
            --disable-static \
            --disable-frontend
%make_build

%install
%makeinstall_std
# Install the backend's config file:
install -d %buildroot%_sysconfdir/sane.d/
install -m 644 backend/epkowa.conf %buildroot%_sysconfdir/sane.d/
# Install the backend's description file:
install -d %buildroot%_datadir/iscan/
# Change the manufacturer name to the same as in SANE's epson.desc file.
#grep -q '^:mfg[[:space:]][[:space:]]*"EPSON"' doc/epkowa.desc || exit 1
#sed -e 's|^:mfg[[:space:]][[:space:]]*"EPSON".*|:mfg "Epson"|' doc/epkowa.desc >%buildroot%_datadir/iscan/epkowa.desc
#mv %buildroot%_libdir/iscan/* %buildroot%_datadir/iscan/
# Remove the installed man page for the "iscan" frontend because it is not included in this package:
rm -f %buildroot%_man1dir/iscan.1

rm -f %buildroot%_libdir/sane/libsane-epkowa.la
#rm -f %buildroot%_datadir/iscan/fix-udev-rules

%files
%_sbindir/iscan-registry
%doc COPYING AUTHORS NEWS README
#KNOWN-PROBLEMS SUPPORTED-DEVICES
%dir %_sysconfdir/sane.d
%config %_sysconfdir/sane.d/epkowa.conf
%dir %_libdir/sane
%_libdir/sane/libsane-epkowa.so*
%_datadir/iscan/
%_man5dir/sane-epkowa.5.*
%_man8dir/*


%changelog
