%define sun_desktop_version 1.6.0.26-alt4
%define origin default
%def_enable desktop

Name: java-common
Version: 1.6.0
Release: alt1

Summary: Common files for Java runtimes
Group: System/Base
License: GPL
Packager: Igor Vlasenko <viy@altlinux.org>
Requires: jpackage-utils

Source: mime-packages.tar

# merged mime data
%if_enabled desktop
#Provides: java-sun-desktop = %sun_desktop_version
Obsoletes: java-sun-desktop < %sun_desktop_version
Conflicts: java-sun-desktop < %sun_desktop_version
%endif

BuildArch: noarch

BuildRequires(pre): rpm-build-java

%description
This package contains the Java profile scripts 
used to select a Java runtime environment available 
in the system to execute Java applications.

%prep
tar xf %{S:0}

%install

# Install profile scripts
# note: they are not needed in jpackage environment
mkdir -p %buildroot%{_sysconfdir}/profile.d/
cat >%buildroot%{_sysconfdir}/profile.d/javahome.sh <<EOF
if test -e %{_prefix}/lib/jvm/java; then
    JAVA_HOME=%{_prefix}/lib/jvm/java
    export JAVA_HOME
elif test -e %{_prefix}/lib/jvm/jre; then
    JAVA_HOME=%{_prefix}/lib/jvm/jre
    export JAVA_HOME
fi
EOF
chmod 755 %buildroot%{_sysconfdir}/profile.d/javahome.sh
cat >%buildroot%{_sysconfdir}/profile.d/javahome.csh <<EOF
if ( -e %{_prefix}/lib/jvm/java ) then
setenv JAVA_HOME %{_prefix}/lib/jvm/java
else if ( -e %{_prefix}/lib/jvm/jre ) then
setenv JAVA_HOME %{_prefix}/lib/jvm/jre
endif
EOF
chmod 755 %buildroot%{_sysconfdir}/profile.d/javahome.csh

# Install /etc/.java/.systemPrefs/ directory
# See https://bugzilla.redhat.com/show_bug.cgi?id=741821
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/.java/.systemPrefs


%if_enabled desktop
install -d -m 755 $RPM_BUILD_ROOT{%_desktopdir,%_datadir/mime/packages/}
mv mime-packages/* $RPM_BUILD_ROOT%{_datadir}/mime/packages/
cat > %buildroot%_datadir/applications/%origin-java.desktop <<'EOF'
[Desktop Entry]
Name=Java
Comment=Java Virtual Machine
Exec=java -jar %f
Icon=java
Terminal=false
Type=Application
NoDisplay=true
Categories=X-ALTLinux-Java;
MimeType=application/x-java-archive;application/x-jar;
InitialPreference=7
EOF

cat > %buildroot%_datadir/applications/%origin-javaws.desktop <<'EOF'
[Desktop Entry]
Name=Java Web Start (system default)
Comment= Java Application Launcher
Exec=javaws %u
Icon=javaws
Terminal=false
Type=Application
NoDisplay=true
Categories=Settings;Java;X-ALTLinux-Java;
MimeType=application/x-java-jnlp-file;
EOF
%endif

%files
%{_sysconfdir}/profile.d/javahome.*sh
#%dir %{_sysconfdir}/.java/
#%dir %{_sysconfdir}/.java/.systemPrefs
%if_enabled desktop
%{_datadir}/mime/packages/*.xml
%_desktopdir/%{origin}-java.desktop
%_desktopdir/%{origin}-javaws.desktop
%endif

%changelog
