Name: jbig
Version: 2.1
Release: alt2

Summary: JBIG-KIT lossless image compression library

License: GPLv2+
Group: Graphics
Url: http://www.cl.cam.ac.uk/~mgk25/jbigkit/

# Source-url: http://www.cl.cam.ac.uk/~mgk25/download/jbigkit-%version.tar.gz
Source: %name-%version.tar

Patch: jbigkit-2.1-shlib.patch
Patch1: jbigkit-2.0-warnings.patch
Patch2: jbigkit-ldflags.patch
# patch for coverity issues - backported from upstream
Patch3: jbigkit-covscan.patch

%define sover %version

%package -n libjbig%sover
Summary: JBIG-KIT lossless image compression library (shared library)
Group: System/Libraries

%package -n libjbig-devel
Summary: JBIG-KIT lossless image compression library (header files)
Group: Development/C
Requires: libjbig%sover = %EVR

%package -n libjbig-devel-static
Summary: JBIG-KIT lossless image compression library (static library)
Group: Development/C
Requires: libjbig-devel = %EVR

%package utils
Summary: JBIG-KIT lossless image compression utilities
Group: Graphics
Requires: libjbig%sover = %EVR
Provides: jbigkit = %version
Obsoletes: jbigkit <= %version

%description
JBIG-KIT provides a portable library of compression and decompression
functions with a documented interface that you can include very easily
into your image or document processing software. In addition, JBIG-KIT
provides ready-to-use compression and decompression programs with a
simple command line interface (similar to the converters found in netpbm).

JBIG-KIT implements the specification:
    ISO/IEC 11544:1993 and ITU-T Recommendation T.82(1993):
     Information technology - Coded representation of picture and audio
     information - Progressive bi-level image compression.

which is commonly referred to as the "JBIG1 standard"

%description -n libjbig%sover
JBIG-KIT provides a portable library of compression and decompression
functions with a documented interface that you can include very easily
into your image or document processing software. In addition, JBIG-KIT
provides ready-to-use compression and decompression programs with a
simple command line interface (similar to the converters found in netpbm).

JBIG-KIT implements the specification:
    ISO/IEC 11544:1993 and ITU-T Recommendation T.82(1993):
     Information technology - Coded representation of picture and audio
     information - Progressive bi-level image compression.

which is commonly referred to as the "JBIG1 standard"

%description -n libjbig-devel
JBIG is a highly effective lossless compression algorithm for bi-level
images (one bit per pixel), which is particularly suitable for scanned
document pages.

This package is only needed if you plan to develop or compile
applications which requires the libjbig library.

%description -n libjbig-devel-static
JBIG is a highly effective lossless compression algorithm for bi-level
images (one bit per pixel), which is particularly suitable for scanned
document pages.

This package contains static JBIG library.

%description utils
JBIG is a highly effective lossless compression algorithm for bi-level
images (one bit per pixel), which is particularly suitable for scanned
document pages.

%prep
%setup
%patch0 -p1 -b .shlib
%patch1 -p1 -b .warnings
# jbigkit: Partial Fedora build flags injection (bug #1548546)
%patch2 -p1 -b .ldflags
# covscan issues - backported from upstream
%patch3 -p1 -b .covscan

%build
%make_build CCFLAGS='%optflags'

LD_LIBRARY_PATH=$PWD/libjbig make test

%install
mkdir -p %buildroot{%_bindir,%_libdir,%_includedir,%_man1dir}
install -p -m755 pbmtools/{jbgtopbm,pbmtojbg} %buildroot%_bindir/
install -p -m644 pbmtools/*.1 %buildroot%_man1dir/
install -p -m0644 libjbig/jbig.h %buildroot%_includedir
install -p -m0644 libjbig/jbig85.h %buildroot%_includedir
install -p -m0644 libjbig/jbig_ar.h %buildroot%_includedir

install -p -m0755 libjbig/libjbig.so.%version %buildroot%_libdir
install -p -m0755 libjbig/libjbig85.so.%version %buildroot%_libdir
ln -sf libjbig.so.%version %buildroot%_libdir/libjbig.so
ln -sf libjbig85.so.%version %buildroot%_libdir/libjbig85.so

%if_enabled static
cp -a libjbig/libjbig.a %buildroot%_libdir/
%endif

%define pkgdocdir %_docdir/jbig-%version
mkdir -p %buildroot%pkgdocdir
cp -a ANNOUNCE CHANGES %buildroot%pkgdocdir/
cp -a INSTALL %buildroot%pkgdocdir/README
#cp -a libjbig/jbig.doc %buildroot%pkgdocdir/jbig.txt

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make -k test

%files -n libjbig%sover
%_libdir/libjbig.so.%sover
%_libdir/libjbig85.so.%sover
%dir %pkgdocdir
%pkgdocdir/ANNOUNCE
%pkgdocdir/CHANGES
%pkgdocdir/README

%files -n libjbig-devel
%_libdir/libjbig.so
%_libdir/libjbig85.so
%_includedir/jbig*.h
%dir %pkgdocdir
#pkgdocdir/jbig.txt

%if_enabled static
%files -n libjbig-devel-static
%_libdir/libjbig.a
%endif

%files utils
%_bindir/jbgtopbm
%_bindir/pbmtojbg
%_man1dir/jbgtopbm.*
%_man1dir/pbmtojbg.*

%changelog
