Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          jdom2
Version:       2.0.6
Release:       alt1_21jpp11
Summary:       Java manipulation of XML made easy
License:       Saxpath
URL:           http://www.jdom.org/
# ./generate-tarball.sh
Source0:       %{name}-%{version}.tar.gz
# originally taken from http://repo1.maven.org/maven2/org/jdom/jdom-contrib/1.1.3/jdom-contrib-1.1.3.pom
Source1:       jdom-contrib-template.pom
Source2:       jdom-junit-template.pom
# Bnd tool configuration
Source3:       bnd.properties
# Remove bundled jars that might not have clear licensing
Source4:       generate-tarball.sh
# Use system libraries
# Disable gpg signatures
# Process contrib and junit pom files
Patch0:        0001-Adapt-build.patch
Patch1:        0002-More-adapt-build-javac-1.8.patch

BuildRequires: javapackages-local
BuildRequires: ant
BuildRequires: ant-junit
BuildRequires: jaxen
BuildRequires: xalan-j2
BuildRequires: xerces-j2
BuildRequires: xml-commons-apis
BuildRequires: aqute-bnd

BuildArch:     noarch
Source44: import.info

%description
JDOM is a Java-oriented object model which models XML documents.
It provides a Java-centric means of generating and manipulating
XML documents. While JDOM inter-operates well with existing
standards such as the Simple API for XML (SAX) and the Document
Object Model (DOM), it is not an abstraction layer or
enhancement to those APIs. Rather, it seeks to provide a robust,
light-weight means of reading and writing XML data without the
complex and memory-consumptive options that current API
offerings provide.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n jdom-JDOM-%{version}

%patch0 -p1
%patch1 -p1

cp -p %{SOURCE1} maven/contrib.pom
cp -p %{SOURCE2} maven/junit.pom

sed -i 's/\r//' LICENSE.txt README.txt

# Unable to run coverage: use log4j12 but switch to log4j 2.x
sed -i.coverage "s|coverage, jars|jars|" build.xml

mkdir lib
build-jar-repository lib xerces-j2 xml-commons-apis jaxen junit xalan-j2 xalan-j2-serializer

# drop optional isorelax verifier support from contrib
rm -r contrib/src/java/org/jdom2/contrib/schema

%build
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Dversion=%{version} -Dj2se.apidoc=%{_javadocdir}/java maven

# Make jar into an OSGi bundle
bnd wrap --output build/package/jdom-%{version}.bar --properties %{SOURCE3} \
         --version %{version} build/package/jdom-%{version}.jar
mv build/package/jdom-%{version}.bar build/package/jdom-%{version}.jar

%install
%mvn_artifact build/maven/core/%{name}-%{version}.pom build/package/jdom-%{version}.jar
%mvn_artifact build/maven/core/%{name}-%{version}-contrib.pom build/package/jdom-%{version}-contrib.jar
%mvn_artifact build/maven/core/%{name}-%{version}-junit.pom build/package/jdom-%{version}-junit.jar
%mvn_install -J build/apidocs

%files -f .mfiles
%doc CHANGES.txt COMMITTERS.txt README.txt TODO.txt
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
