%define oldname junit
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-default
BuildRequires: javapackages-local
# Copyright (c) 2000-2012, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

Name:           junit3
Version:        3.8.2
Release:	alt12_10jpp6
Epoch:          1
Summary:        Java regression test package
License:        CPL
Url:            http://www.junit.org/
Group:          Development/Java
#http://osdn.dl.sourceforge.net/junit/junit3.8.2.zip
Source0:        junit3.8.2.zip
Source1:        junit3.8.2-build.xml
Source2:        junit-component-info.xml
Source3:        http://repo1.maven.org/maven2/junit/junit/3.8.2/junit-3.8.2.pom
BuildRequires:  ant
Buildarch:      noarch
Source44: import.info
Conflicts: junit < 3.8.3

%description
JUnit is a regression testing framework written by Erich Gamma and Kent
Beck. It is used by the developer who implements unit tests in Java.
JUnit is Open Source Software, released under the IBM Public License and
hosted on SourceForge.

%package manual
Group:          Development/Java
Summary:        Manual for %{name}
BuildArch: noarch

%description manual
Documentation for %{name}.

%package javadoc
Group:          Development/Documentation
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%package demo
Group:          Development/Java
Summary:        Demos for %{name}
Requires:       %{name} = %{epoch}:%{version}-%{release}

%description demo
Demonstrations and samples for %{name}.

%prep
%setup -q -n %{oldname}%{version}
%{jar} xf src.jar
rm src.jar
cp -p %{SOURCE1} build.xml
rm -r javadoc

%build
export CLASSPATH=
export OPT_JAR_LIST=:
%{ant} -Dant.build.javac.source=1.6 -Dant.build.javac.target=1.6  dist

%mvn_artifact %{SOURCE3} %{oldname}%{version}/%{oldname}.jar
%mvn_compat_version : 3 %{version}

%install
%mvn_install -J %{oldname}%{version}/javadoc

# demo
# Not using %%name for last part because it is part of package name
mkdir -p %{buildroot}%{_datadir}/%{name}/demo/junit
cp -pr %{oldname}%{version}/%{oldname}/* %{buildroot}%{_datadir}/%{name}/demo/junit

%files -f .mfiles
%doc cpl-v10.html README.html

%files javadoc -f .mfiles-javadoc

%files manual
# FIXME: (dwalluck) Manuals are usually stored in an absolute location inside %%{_docdir}
%doc %{oldname}%{version}/doc/*

%files demo
%{_datadir}/%{name}

%changelog
