%define rname spectacle
%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif
%define service_name app-org.kde.spectacle

Name: kde5-%rname
Version: 23.08.5
Release: alt1
%K5init

Group: Graphical desktop/KDE
Summary: The KDE Screenshot Utility
Url: http://www.kde.org
License: LGPL-2.0-or-later AND GPL-2.0-or-later

Source: %rname-%version.tar
Patch1: alt-services-paths.patch
Patch2: alt-desktop-exec.patch
Patch3: alt-kimageannotator-tr.patch
Patch4: alt-def-capture-mode.patch

# Automatically added by buildreq on Wed May 11 2016 (-bi)
# optimized out: cmake cmake-modules docbook-dtds docbook-style-xsl elfutils gcc-c++ gtk-update-icon-cache kf5-kdoctools kf5-kdoctools-devel libEGL-devel libGL-devel libdbusmenu-qt52 libgpg-error libjson-c libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-printsupport libqt5-qml libqt5-quick libqt5-svg libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcb-devel libxcb-render-util libxcbutil-cursor libxcbutil-image libxcbutil-keysyms perl pkg-config python-base python-modules python3 python3-base qt5-base-devel rpm-build-python3 xml-common xml-utils
#BuildRequires: extra-cmake-modules kde5-libkipi-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdelibs4support kf5-kdoctools-devel kf5-ki18n-devel kf5-kio-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kpackage-devel kf5-kservice-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-libkscreen-devel kf5-solid-devel libxcbutil-cursor-devel libxcbutil-devel libxcbutil-image-devel python-module-google python3-dev qt5-declarative-devel qt5-x11extras-devel ruby ruby-stdlibs
BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules qt5-declarative-devel qt5-x11extras-devel qt5-svg-devel qt5-quickcontrols2-devel
BuildRequires: qt5-wayland-devel kde5-plasma-wayland-protocols
BuildRequires: pipewire-libs-devel plasma5-kpipewire-devel
BuildRequires: libxcbutil-cursor-devel libxcbutil-devel libxcbutil-image-devel
BuildRequires: kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel
BuildRequires: kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdelibs4support kf5-kdoctools-devel
BuildRequires: kf5-ki18n-devel kf5-kio-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kpackage-devel
BuildRequires: kf5-kservice-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel
BuildRequires: kf5-solid-devel kf5-knewstuff-devel kf5-kglobalaccel-devel kf5-kwayland-devel
BuildRequires: kf5-purpose-devel kf5-kirigami-devel
BuildRequires: plasma5-libkscreen-devel
BuildRequires: kde5-kcolorpicker-devel kde5-kimageannotator-devel

%description
Spectacle is screenshot taking utility for the KDE desktop. Spectacle
can also be used in non-KDE X11 desktop environments.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1
#%patch3 -p1
#%patch4 -p1

%build
%K5build \
    -DDATA_INSTALL_DIR=%_K5data \
    #

%install
%K5install
%K5install_move data kglobalaccel kconf_update locale
%find_lang %name --with-kde --all-name

%files -f %name.lang
%doc LICENSES/*
%_K5bin/spectacle
%_K5conf_bin/*spectacle*
%_K5conf_up/*spectacle*
%_K5xdgapp/org.kde.spectacle.desktop
%_K5icon/hicolor/*/apps/spectacle.*
%_K5notif/spectacle.notifyrc
%_K5data/kglobalaccel/*spectacle*.desktop
%_K5dbus_srv/org.kde.Spectacle.service
%_K5conf_up/*.upd
%_K5conf_up/*.py
%_datadir/qlogging-categories5/*.*categories
%_unitdir_user/%service_name.service
%_datadir/metainfo/*.xml

#%files devel
#%_K5dbus_iface/org.kde.Spectacle.xml

%changelog
