%def_with devel

Name: kumir2
Version: 2.1.0
Release: alt11.git4cba2673

Summary: New version of Kumir - simple programming language and IDE for teaching programming
Summary(ru_RU.UTF-8): Новая версия системы Кумир - простого учебного языка программирования и среды разработки

License: GPL-2.0
Group: Education
URL:  https://www.niisi.ru/kumir/
VCS: https://github.com/a-a-maly/kumir2/
Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): cmake rpm-build-python3
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: qt5-base-devel >= 5.3
BuildRequires: qt5-svg-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: qt5-script-devel
BuildRequires: qt5-tools
BuildRequires: python3 >= 3.2
BuildRequires: git-core
BuildRequires: boost-devel
BuildRequires: bzlib-devel

Source: %name-%version.tar
Patch1: kumir2-alt-fix-LIB_BASENAME.patch
Patch2: port-to-python3.patch
Patch3: 0001-Fixed-build-with-GCC-13.x.patch

%description
Implementation of Kumir programming language, designed by academician
Ershov. It has very simple syntax, also known as "Russian algorithmical
language". Includes compiler, runtime, IDE and  modules "Robot", "Draw",
"Turtle" and some others.

This is a second generation of well-known Kumir system. ALT Linux
package also supports a real world actor from the UMKI project:
http://vinforika.ru/umki/

%description -l ru_RU.UTF-8
Кумир - это учебный язык программирования, описанный в учебнике
А.Г.Кушниренко, и среда разработки. Он имеет простой синтаксис,
известный также как "русский алгоритмический язык". В состав среды также
входят канонические исполнители Робот, Чертежник, Черепаха и другие,
что делает Кумир очень удобным для начального обучения программированию.

Пакет kumir2 содержит новую реализацию системы Кумир. Версия пакета
ALT Linux включает также поддержку исполнителя, являющегося объектом
реального мира -- разработанного в рамках проекта УМКИ
радиоуправляемого робота.

%if_with devel
%package devel
Group: Education
Summary: Development files for Kumir
Requires: %name = %EVR

%description devel
Development files for Kumir.
%endif

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
sed -i "s/^Categories=.*$/Categories=Education;Qt;ComputerScience;/" *.desktop
# Remove bundled boost
rm -rf src/3rdparty/boost*

%build
export PATH=%_qt5_bindir:$PATH
%cmake  -GNinja -Wno-dev\
	-DUSE_QT=5 \
	-DLIB_BASENAME=%_lib \
	-DPROVIDED_VERSION_INFO=TRUE \
	-DGIT_HASH=4cba2673 \
	-DGIT_TIMESTAMP=20230427 \
	-DGIT_TAG=2.1.0-rc11 \
	-DGIT_BRANCH=master
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"

%files
%_bindir/*
%_libdir/%name
%_datadir/%name
%_datadir/mime/packages/*.xml
%_desktopdir/*
%_iconsdir/*/*/*/*

%if_with devel
%ifarch %ix86 x86_64
%files devel
%_includedir/kumir2-libs
%_includedir/kumir2
%_libdir/cmake/Kumir2
%endif
%endif

%changelog
