%define _unpackaged_files_terminate_build 1

%define _localstatedir  %_var

%define jss_version 4.9.5-alt1
%define java_version 11

Name: ldapjdk
Epoch: 1
Version: 4.23.0
Release: alt1

Summary: LDAP SDK
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: Development/Java
# Source-git: https://github.com/dogtagpki/ldap-sdk.git
Url: https://www.dogtagpki.org/wiki/LDAP_SDK

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-java
BuildRequires: rpm-build-java

BuildRequires: /proc
BuildRequires: ant
BuildRequires: java-devel >= %java_version
BuildRequires: javapackages-local
BuildRequires: javapackages-tools
BuildRequires: jss >= %jss_version

BuildArch: noarch

Provides: ldapsdk = 1:%version-%release
Obsoletes: ldapsdk <= 1:4.18-alt1_2jpp6

Requires: jss >= %jss_version
Requires: java >= %java_version

%description
The Mozilla LDAP SDKs enable you to write applications which access,
manage, and update the information stored in an LDAP directory.

################################################################################
%package javadoc
Group: Development/Documentation
################################################################################

Summary: Javadoc for %name
BuildArch: noarch

%description javadoc
Javadoc for %name

################################################################################
%prep
################################################################################

%setup
%patch -p1

# Remove all bundled jars, we must build against build-system jars
rm ./java-sdk/ldapjdk/lib/*

################################################################################
%build
################################################################################

pushd ./java-sdk/ldapjdk/lib
build-jar-repository -s -p . jss

ln -s /usr/lib/jvm-exports/java/{jsse,jaas,jndi}.jar ./
pushd ../../
%ant -v dist

################################################################################
%install
################################################################################

install -d -m 755 %buildroot%_javadir
install -m 644 java-sdk/dist/packages/%name.jar %buildroot%_javadir/%name.jar
install -m 644 java-sdk/dist/packages/ldapsp.jar %buildroot%_javadir/ldapsp.jar
install -m 644 java-sdk/dist/packages/ldapfilt.jar %buildroot%_javadir/ldapfilt.jar
install -m 644 java-sdk/dist/packages/ldapbeans.jar %buildroot%_javadir/ldapbeans.jar

mkdir -p %buildroot%_mavenpomdir
install -pm 644 java-sdk/ldapjdk/pom.xml %buildroot%_mavenpomdir/JPP-ldapjdk.pom
install -pm 644 java-sdk/ldapfilter/pom.xml %buildroot%_mavenpomdir/JPP-ldapfilter.pom
install -pm 644 java-sdk/ldapbeans/pom.xml %buildroot%_mavenpomdir/JPP-ldapbeans.pom
install -pm 644 java-sdk/ldapsp/pom.xml %buildroot%_mavenpomdir/JPP-ldapsp.pom

install -d -m 755 %buildroot%_javadocdir/%name
cp -r java-sdk/dist/doc/* %buildroot%_javadocdir/%name
ln -s ldapjdk.jar %buildroot%_javadir/ldapsdk.jar

################################################################################
%files
################################################################################

%_javadir/%name.jar
%_javadir/ldapsp.jar
%_javadir/ldapfilt.jar
%_javadir/ldapbeans.jar
%_javadir/ldapsdk.jar
%_mavenpomdir/JPP-ldapjdk.pom
%_mavenpomdir/JPP-ldapsp.pom
%_mavenpomdir/JPP-ldapfilter.pom
%_mavenpomdir/JPP-ldapbeans.pom

################################################################################
%files javadoc
################################################################################

%dir %_javadocdir/%name
%_javadocdir/%name/*

################################################################################
%changelog
