# wait for GTEST_ALLOW_UNINSTANTIATED_PARAMETERIZED_TEST
%def_without test
Name: libabseil-cpp
Version: 20210324.2
Release: alt1

Summary: C++ Common Libraries

License: Apache-2.0
Group: Development/C++
Url: https://abseil.io

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/abseil/abseil-cpp/archive/%version/abseil-cpp-%version.tar.gz
Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: gcc-c++

BuildRequires: libgtest-devel libgmock-devel ctest

%description
Abseil is an open-source collection of C++ library code designed to augment
the C++ standard library. The Abseil library code is collected from
Google's own C++ code base, has been extensively tested and used in
production, and is the same code we depend on in our daily coding lives.

In some cases, Abseil provides pieces missing from the C++ standard; in
others, Abseil provides alternatives to the standard for special needs we've
found through usage in the Google code base. We denote those cases clearly
within the library code we provide you.

Abseil is not meant to be a competitor to the standard library; we've just
found that many of these utilities serve a purpose within our code base,
and we now want to provide those resources to the C++ community as a whole.

%package devel
Summary: Development files for %name
#Requires: %name = %EVR
Group: Development/C++

%description devel
Development headers for %name

%prep
%setup

%build
%add_optflags "-fPIC"
# about -DCMAKE_CXX_STANDARD=17 see https://github.com/desktop-app/tg_owt/pull/55#discussion_r599718405
%cmake_insource -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_CXX_STANDARD=17 \
%if_with test
    -DABSL_RUN_TESTS=ON -DABSL_USE_EXTERNAL_GOOGLETEST=ON \
%endif
    -DABSL_ENABLE_INSTALL=ON
%make_build

%install
%makeinstall_std

%if_with test
%check
ctest
%endif

%files devel
%doc LICENSE
%doc *.md
%_libdir/libabsl_*.a
#files devel
%_includedir/absl/
%_libdir/cmake/absl/
%_pkgconfigdir/*.pc

%changelog
