Name: libbelle-sip
Version: 1.6.3
Release: alt4

Summary: Linphone SIP stack
License: GPL
Group: System/Libraries

Url: http://www.belle-sip.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Alexei Takaseev <taf@altlinux.ru>

# Automatically added by buildreq on Thu Mar 02 2017
# optimized out: antlr3-C bcunit gnu-config java-1.8.0-openjdk-headless libstdc++-devel perl pkg-config python-base python3
BuildRequires: antlr3-C-devel java-devel libmbedtls-devel libbctoolbox-devel gcc8-c++ zlib-devel

BuildRequires: /proc rpm-build-java

%description
Belle-sip is an object oriented c written SIP stack used by Linphone.

%package devel
Summary: Development libraries for belle-sip
Group: Development/Other
Requires: %name = %version-%release

%description devel
Libraries and headers required to develop software with belle-sip

%prep
%setup
%patch -p1
%ifarch %e2k
%add_optflags -std=c11
# -Werror => 'unrecognized character escape sequence' gets fatal
# NB: src/grammars/belle_sip_message.g is *not* to be changed
sed -r -i 's,\\(%%[dsu]),\1,g' src/belle_sip_utils.c src/parserutils.h
# as of lcc-1.23.12; looks like author knows of getTokenNames/freeScope warning
sed -i 's,-fms-extensions,-Wno-error=unused-function -Wno-error=unused-variable -Wno-error=ignored-qualifiers,' configure*
%endif

%build
%ifnarch %e2k
%set_gcc_version 8
export CC="gcc-%{_gcc_version}"
export CXX="g++-%{_gcc_version}"
%endif
%autoreconf
%configure \
	--disable-static \
	--with-antlr=%_builddir/%name-%version \
	--enable-strict=no

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install

%makeinstall

%files
%doc AUTHORS ChangeLog COPYING NEWS README.md
%_libdir/*.so.*

%files devel
%_includedir/belle-sip
%_libdir/libbellesip.so
%_libdir/pkgconfig/belle-sip.pc

%changelog
