Name:       libbenchmark
Version:    1.5.5
Release:    alt2
URL:        https://github.com/google/benchmark
Summary:    A library to benchmark code snippets
Source:     benchmark-%version.tar.gz
Patch:      benchmark-1.5.4-extbuild.patch
Patch2000:  libbenchmark-e2k.patch
License:    Apache-2.0
Group:      Development/C++

# Automatically added by buildreq on Sun Jul 11 2021
# optimized out: cmake-modules glibc-kernheaders-generic glibc-kernheaders-x86 libgmock-devel libsasl2-3 libstdc++-devel python3-base sh4
BuildRequires: cmake gcc-c++ libgtest-devel ctest

%description
A library to benchmark code snippets, similar to unit tests.

Define a function that executes the code to measure, register it as a benchmark
function using the `BENCHMARK` macro, and ensure an appropriate `main` function
is available.

To run the benchmark, compile and link against the `benchmark` library
(libbenchmark.a/.so). If you followed the build steps above, this library will
be under the build directory you created.

%package devel
Summary:    %summary; development environment
Group:      Development/C++

%description devel
%summary; development environment

%package devel-static
Summary:    %summary (static)
Group:      Development/C++

%description devel-static
%summary (static)

%prep
%setup -n benchmark-%version
%patch -p1 
%ifarch %e2k
%patch2000 -p1
%endif

%build
%cmake -DBUILD_SHARED_LIBS:BOOL=FALSE
%cmake_build
mv %_cmake__builddir/src/*.a .
rm -rf %_cmake__builddir
%cmake -DBUILD_SHARED_LIBS:BOOL=TRUE
%cmake_build

%install
%cmake_install
install *.a %buildroot/%_libdir

%check
%make_build -C %_cmake__builddir test

%files
%doc *.md
%_libdir/*.so.*

%files devel
%doc docs
%_libdir/cmake/*
%_pkgconfigdir/*
%_libdir/lib*.so
%_includedir/*

%files devel-static
%_libdir/lib*.a

%changelog
