
Name: libcgroup
Summary: Libraries for allow to control and monitor control groups
Group: System/Libraries
Version: 2.0
Release: alt1
License: LGPLv2+
Url: http://libcg.sourceforge.net/
Packager: Alexey Shabalin <shaba@altlinux.ru>
# VCS: https://github.com/libcgroup/libcgroup.git
Source: %name-%version.tar
Source2: tests.tar
Patch: %name-%version-%release.patch

BuildRequires: flex gcc-c++ libpam-devel

%description
Control groups infrastructure.

This library allows applications to manipulate, control, administrate and
monitor control groups and the associated controllers.

%package -n pam_cgroup
Summary: A Pluggable Authentication Module for libcgroup
Group: System/Base
Requires: libcgroup = %version-%release

%description -n pam_cgroup
Linux-PAM module, which allows administrators to classify the user's login
processes to pre-configured control group.

%package -n cgroup
Summary: Tools to control and monitor control groups
Group: System/Configuration/Other
Requires: libcgroup = %version-%release

%description -n cgroup
Control groups infrastructure.

These tools help manipulate, control, administrate and monitor control groups
and the associated controllers.

%package devel
Summary: Development libraries to develop applications that utilize control groups
Group: Development/C
Requires: libcgroup = %version-%release

%description devel
It provides API to create/delete and modify cgroup nodes. It will also in the
future allow creation of persistent configuration for control groups and
provide scripts to manage that configuration.

%prep
%setup
%patch -p1
tar -xf %SOURCE2 -C tests

%build
%autoreconf
%configure \
	--disable-static \
	--enable-initscript-install \
	--enable-pam-module-dir=/%_lib/security \
	--enable-opaque-hierarchy=name=systemd

%make_build

%install
%make DESTDIR=%buildroot install

# install config files
mkdir -p %buildroot%_sysconfdir/sysconfig
cp samples/cgred.conf %buildroot%_sysconfdir/sysconfig/cgred
cp samples/cgconfig.sysconfig %buildroot%_sysconfdir/sysconfig/cgconfig
cp samples/cgconfig.conf %buildroot%_sysconfdir/cgconfig.conf
cp samples/cgrules.conf %buildroot%_sysconfdir/cgrules.conf
cp samples/cgsnapshot_blacklist.conf %buildroot%_sysconfdir/cgsnapshot_blacklist.conf

rm -f %buildroot/%_lib/security/pam_cgroup.la
rm -f %buildroot%_libdir/*.la
rm -f %buildroot%_libdir/libcgroupfortesting.*

mkdir -p %buildroot%_sysconfdir/cgconfig.d
# install unit and sysconfig files
install -d %buildroot%_unitdir
install -m 644 dist/cgconfig.service %buildroot%_unitdir/
install -m 644 cgred.service %buildroot%_unitdir/

%pre -n cgroup
%_sbindir/groupadd -r -f cgred 2> /dev/null ||:

%post -n cgroup
%post_service cgred
%post_service cgconfig

%preun -n cgroup
%preun_service cgred
%preun_service cgconfig

%files
%_libdir/*.so.*

%files -n cgroup
%doc COPYING INSTALL README README_daemon README_systemd
%config(noreplace) %_sysconfdir/sysconfig/cgred
%config(noreplace) %_sysconfdir/sysconfig/cgconfig
%config(noreplace) %_sysconfdir/cgconfig.conf
%config(noreplace) %_sysconfdir/cgrules.conf
%config(noreplace) %_sysconfdir/cgsnapshot_blacklist.conf
%dir %_sysconfdir/cgconfig.d
%attr(2711, root, cgred) %_bindir/cgexec
%attr(2711, root, cgred) %_bindir/cgclassify
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man5dir/*
%_man8dir/*
%config %_initdir/cgconfig
%config %_initdir/cgred
%_unitdir/cgconfig.service
%_unitdir/cgred.service

%files -n pam_cgroup
%_pam_modules_dir/pam_cgroup.so

%files devel
%doc COPYING INSTALL
%_includedir/libcgroup.h
%_includedir/libcgroup
%_libdir/*.so
%_pkgconfigdir/libcgroup.pc

%changelog
