%def_disable snapshot

%define oname cogl
%define ver_major 1.22
%define gst_api_ver 1.0
%define gles2_libname libGLESv2.so.2

%ifarch %arm
%def_enable gles2
%def_disable gl
%else
%def_disable gles2
%def_enable gl
%endif

%def_enable cairo
%def_disable gst
%def_disable profile

%def_enable glib
%def_enable cogl_pango
%def_enable gdk_pixbuf
%def_disable examples_install

%def_enable wayland_egl
%def_enable wayland_server
%def_enable kms_egl
%def_enable xlib_egl
%def_enable deprecated
%def_enable apidocs
%def_enable unit_tests

Name: libcogl
Version: %ver_major.8
Release: alt2

Summary: A library for using 3D graphics hardware to draw pretty pictures
Group: System/Libraries
License: MIT
Url: http://www.clutter-project.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%oname/%ver_major/%oname-%version.tar.xz
%else
Source: %oname-%version.tar
%endif
Patch: cogl-1.16.1-alt-gles2.patch
Patch1: cogl-1.22.8-alt-egl-glvnd.patch

# fc patches
# Vaguely related to https://bugzilla.gnome.org/show_bug.cgi?id=772419
# but on the 1.22 branch, and the static inline in the header is gross
# ajax promises he'll clean this up.
Patch10: 0001-egl-Use-eglGetPlatformDisplay-not-eglGetDisplay.patch
# "GL_ARB_shader_texture_lod" is used to do lod biased texturing. It
# make achieve faster blurring of images instead of using large blur radius.
Patch11: 0002-add-GL_ARB_shader_texture_lod-support.patch
# "copy_sub_image" is used to implement feature similar with kwin blur
# effect by being abel to copy partial of framebuffer contents as texture
# and do post blurring.
Patch12: 0003-texture-support-copy_sub_image.patch

# e2k build fix with lcc 1.24.11
Patch2000: cogl-1.22.8-alt-e2k-initialize-attribute.patch

Conflicts: libclutter < 1.8.0

%define glib_ver 2.32.0
%define pangocairo_ver 1.20
%define gi_ver 0.9.5
%define gdk_pixbuf_ver 2.0
%define uprof_ver 0.3
%define gtk_doc_ver 1.13
%define xfixes_ver 3
%define xcomposite_ver 0.4
%define xrandr_ver 1.2
%define cairo_ver 1.10
%define wayland_ver 1.0.0

%{?_enable_cairo:BuildRequires: pkgconfig(cairo) >= %cairo_ver pkgconfig(cairo-gobject)}
%{?_enable_profile:BuildRequires: pkgconfig(uprof-0.3) >= %uprof_ver}
%{?_enable_glib:BuildRequires: pkgconfig(gobject-2.0) pkgconfig(gmodule-no-export-2.0) pkgconfig(glib-2.0)}
%{?_enable_cogl_pango:BuildRequires: pkgconfig(pangocairo) >= %pangocairo_ver}
%{?_enable_gdk_pixbuf:BuildRequires: pkgconfig(gdk-pixbuf-2.0) >= %gdk_pixbuf_ver}
%{?_enable_gles2:BuildRequires: pkgconfig(glesv2)}
%{?_enable_gl:BuildRequires: pkgconfig(x11) pkgconfig(gl)}
%{?_enable_wayland_egl:BuildRequires: pkgconfig(wayland-egl) >= %wayland_ver pkgconfig(wayland-client) >= %wayland_ver}
%{?_enable_kms_egl:BuildRequires: pkgconfig(gbm) pkgconfig(libdrm)}
%{?_enable_wayland_server:BuildRequires: pkgconfig(wayland-server) >= %wayland_ver}
%{?_enable_xlib_egl:BuildRequires: pkgconfig(egl) pkgconfig(x11) pkgconfig(xext) pkgconfig(xfixes) >= %xfixes_ver pkgconfig(xdamage) pkgconfig(xcomposite) >= %xcomposite_ver pkgconfig(xrandr) >= %xrandr_ver}
%{?_enable_gst:BuildRequires: gst-plugins%gst_api_ver-devel}
BuildRequires: gtk-doc >= %gtk_doc_ver
BuildRequires: gobject-introspection-devel >= %gi_ver  gir(GL) = 1.0 gir(GObject) = 2.0
BuildRequires: gir(Pango) = 1.0 gir(PangoCairo) = 1.0 gir(Gst) = 1.0

%description
Cogl is a small open source library for using 3D graphics hardware to draw
pretty pictures. The API departs from the flat state machine style of
OpenGL and is designed to make it easy to write orthogonal components that
can render without stepping on each others toes.

As well aiming for a nice API, we think having a single library as opposed
to an API specification like OpenGL has a few advantages too; like being
able to paper over the inconsistencies/bugs of different OpenGL
implementations in a centralized place, not to mention the myriad of OpenGL
extensions. It also means we are in a better position to provide utility
APIs that help software developers since they only need to be implemented
once and there is no risk of inconsistency between implementations.

Having other backends, besides OpenGL, such as drm, Gallium or D3D are
options we are interested in for the future.

%package devel
Summary: %oname development environment
Group: Development/C
Requires: %name = %version-%release
Conflicts: libclutter-devel < 1.8.0

%description devel
Header files and libraries for building and developing apps with %oname.

%package gir
Summary: GObject introspection data for the %oname
Group: System/Libraries
Requires: %name = %version-%release
Conflicts: libclutter-gir < 1.8.0

%description gir
GObject introspection data for the %oname

%package gir-devel
Summary: GObject introspection devel data for the %oname
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release %name-devel = %version-%release
Conflicts: libclutter-gir-devel < 1.8.0

%description gir-devel
GObject introspection devel data for the %oname

%package devel-doc
Summary: Development package for %oname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Contains developer documentation for %oname.

%package -n gst-plugins-%oname%gst_api_ver
Summary: Cogl plugin for Gstreamer-1.0
Group: System/Libraries
Requires: %name = %version-%release

%description -n gst-plugins-%oname%gst_api_ver
This package provides Cogl plugin for Gstreamer (1.0 API version)

%prep
%setup -n %oname-%version
%patch -p1
%patch1 -p1 -b .glvnd
%patch10 -p1
%patch11 -p1
%patch12 -p1
%ifarch %e2k
%patch2000 -p1
%endif

%build
%autoreconf
%configure  \
	--disable-static \
	%{subst_enable profile} \
	%{subst_enable cairo} \
	%{subst_enable glib} \
	%{?_enable_cogl_pango:--enable-cogl-pango} \
	%{?_enable_examples_install:--enable-examples-install} \
	%{?_enable_apidocs:--enable-gtk-doc} \
	--enable-introspection \
	%{subst_enable gl} \
	%{subst_enable gles2} \
	%{?_enable_kms_egl:--enable-kms-egl-platform } \
	%{?_enable_wayland_egl:--enable-wayland-egl-platform} \
	%{?_enable_wayland_server:--enable-wayland-egl-server} \
	%{?_enable_xlib_egl:--enable-xlib-egl-platform} \
	%{?_enable_gst:--enable-cogl-gst} \
	%{subst_enable deprecated} \
	%{?_disable_unit_tests:--enable-unit-tests=no} \
	--with-gles2-libname=%gles2_libname

%make_build

%install
%makeinstall_std
%find_lang %oname

%files -f %oname.lang
%doc COPYING NEWS README ChangeLog
%_libdir/libcogl*.so.*

%if_enabled gst
%files -n gst-plugins-%oname%gst_api_ver
%_libdir/gstreamer-%gst_api_ver/libgstcogl.so
%exclude %_libdir/gstreamer-%gst_api_ver/*.la
%endif

%files devel
%_includedir/cogl
%_libdir/libcogl*.so
%_pkgconfigdir/*.pc

%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir

%if_enabled apidocs
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%{?_disable_examples_install:%exclude %_datadir/cogl/examples-data}

%changelog
