%def_without devel
%define oldname libctl
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/indent libnlopt-devel libreadline-devel
# END SourceDeps(oneline)
BuildRequires: chrpath
Group: System/Legacy libraries
%add_optflags %optflags_shared
Name:           libctl5
Version:        3.2.2
Release:        alt3_3
Summary:        Guile-based support for flexible control files
# integrator.c and cintergrator.c contain code licensed under GPLv2+
# The rest of the code is LGPLv2+, but most restrictive license wins
# for the package.
License:        GPLv2+
URL:            http://ab-initio.mit.edu/wiki/index.php/Libctl
Source0:        http://ab-initio.mit.edu/libctl/libctl-%{version}.tar.gz
Patch0:         0001-Add-check-for-sincos-function-from-libm-to-configure.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gcc-fortran
BuildRequires:  guile-devel
BuildRequires:  libtool
Requires:       guile
Source44: import.info

%description
libctl is a Guile-based library that provides support for
flexible control files in scientific simulations.

%package -n libctl
Group: System/Legacy libraries
Summary:        Guile-based support for flexible control files

%description -n libctl
libctl is a Guile-based library that provides support for
flexible control files in scientific simulations.

%package        devel
Group: Development/C
Summary:        Development files for %{name}
Requires:       %{name}%{?_isa} = %{version}

%description    devel
This package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q -n %oldname-%version
%patch0 -p1

%build
autoreconf -fiv
F77=gfortran              \
%configure                \
        --disable-rpath   \
        --enable-shared   \
        --disable-static  \
        --includedir=%{_includedir}/ctl

%make_build

%install
%makeinstall_std

find %{buildroot} -name '*.la' -delete -print
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111`; do
	chrpath -d $i ||:
done

%files -n libctl
%doc COPYING COPYRIGHT
%{_libdir}/libctl*.so.*

%if_with devel
%files devel
%doc AUTHORS NEWS
%doc doc/
%{_bindir}/gen-ctl-io
%{_includedir}/ctl/
%{_libdir}/libctl*.so
%{_mandir}/man1/gen-ctl-io.1*
%{_datadir}/libctl/
%endif

%changelog
