%define vrs	3.1
%define tstamp 	20191231
#def_enable Werror

Name: libedit3
Version: %vrs.%tstamp
Release: alt1

Summary: The BSD editline library
License: BSD-3-Clause
Group: System/Libraries
Url: https://www.thrysoee.dk/editline/

# Repacked https://www.thrysoee.dk/editline/libedit-%tstamp-%vrs.tar.gz
Source: libedit-%tstamp-%vrs.tar

Patch0: libedit-alt-use-OpenBSD-soname.patch
Patch1: libedit-alt-configure-AC_SYS_LARGEFILE.patch

# Automatically added by buildreq on Tue Feb 15 2011
BuildRequires: groff-base libtinfo-devel

%description
This is an autotool- and libtoolized port of the NetBSD Editline
library (libedit). This Berkeley-style licensed command line
editor library provides generic line editing, history, and
tokenization functions, similar to those found in GNU Readline.

%package -n libedit-devel
Summary: Files needed to develop programs which use the %name library
Group: Development/C
Requires: %name = %EVR

%description -n libedit-devel
This package contains the files needed to develop programs which use
the %name library to provide an easy to use and more intuitive
command line interface for users.

%prep
%setup -q -n libedit-%tstamp-%vrs
%patch0 -p2
%patch1 -p2
rm aclocal.m4 m4/*.m4

%build
%add_optflags %optflags_warnings -Wunused-function -Wunused-label -Wunused-variable -Wunused-value
%autoreconf
%configure \
	--disable-examples \
	--disable-static \
#
%make_build

%install
%makeinstall_std

# In 20160618-3.1 some manpages dropped prefix for some reason.
cd %buildroot%_man3dir
	for m in tok_*.3 history*.3 ; do
		mv -v "$m" el_"$m"
	done
cd -

%set_verify_elf_method strict
%define _stripped_files_terminate_build 1
%define _unpackaged_files_terminate_build 1

%files
%_libdir/*.so.*
%_man5dir/*
%_man7dir/*

%files -n libedit-devel
%_libdir/*.so
%_pkgconfigdir/libedit.pc
%_includedir/*
%_man3dir/*

%changelog
