Name: libexplain
Version: 1.4
Release: alt3

Summary: Library functions to explain system call errors

Url: http://libexplain.sourceforge.net

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://downloads.sourceforge.net/%name/%name-%version.tar
Patch0: libexplain-1.4-syscall.patch
Patch1: libexplain-1.4-largefile.patch
Patch2: libexplain-1.4-missed-defines.patch
Patch3: libexplain-1.4-gcc-10.patch
Patch4: libexplain-1.4-nettstamp-needs-types.patch
Patch5: libexplain-1.4-sanitize-bison.patch
Patch6: libexplain-1.4-typos.patch
Patch7: libexplain-1.4-remove-termiox.patch

License: LGPLv3+
Group: System/Libraries

# See libexplain-1.4-remove-termiox.patch
BuildRequires: glibc-kernheaders >= 5.12

BuildRequires: bison libacl-devel libcap-devel libtool lsof gettext-tools
BuildRequires: ghostscript-utils groff-base groff-ps

%{!?_pkgdocdir: %global _pkgdocdir %_docdir/%name-%version}

%description
The libexplain project provides a library which may be used to explain
Unix and Linux system call errors. This will make your application's
error messages much more informative to your users.  The library is
not quite a drop-in replacement for strerror, but it comes close. Each
system call has a dedicated libexplain function.

The coverage for system calls is being improved all the time. Coverage
includes 159 system calls and 444 ioctl requests.

%package -n explain
Summary: Explains system call error reports
License: GPLv3+
Group: Development/Tools
Requires: libexplain = %EVR

%description -n explain
The explain command is used to decode an error return read from an
strace(1) listing, or similar.  Because this is being deciphered in a
different process than the original, the results will be less accurate
than if the program itself were to use libexplain(3).

%package devel
Summary: Development files for libexplain
License: LGPLv3+ and GPLv3+
Group: Development/C
Requires: libexplain = %EVR
Requires: pkg-config

%description devel
Development files for the libexplain library.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

# hack against missed dlci_add struct
%__subst "s|#ifdef SIOCADDDLCI|#ifdef IGNORE_SIOCADDDLCI|" libexplain/iocontrol/siocadddlci.c
%__subst "s|#ifdef SIOCDELDLCI|#ifdef IGNORE_SIOCDELDLCI|" libexplain/iocontrol/siocdeldlci.c

# Propagate %%{_pkgdocdir} into Makefile.in
case "%_pkgdocdir" in
*/libexplain-%version )
  sed -i "s,\$(datarootdir)/doc/libexplain,\$(datarootdir)/doc/libexplain-%version," Makefile.in
  ;;
esac

%build
# formerly used --disable-static, but configure says it is unrecognized
%configure
%make_build

%check
# TODO: 
# Invalid argument (EINVAL) because unknown protocol, or protocol family not available
# FAILED test of socket EPROTONOSUPPORT
make check || :

%install
# The install target is not smp-safe, so don't use smp_mflags.
make DESTDIR=%buildroot \
     install
# The shared library has to be executable!
chmod 755 %buildroot%_libdir/%name.so.*.*.*
# Get rid of the static library and libtool archives
rm %buildroot%_libdir/%name.{a,la}

# Add files to docs
install -m 0664 README LICENSE %buildroot%_pkgdocdir


%files
%_libdir/%name.so.*
%_datadir/locale/de/LC_MESSAGES/%name.mo
%dir %doc %_pkgdocdir
%doc %_pkgdocdir/README
%doc %_pkgdocdir/LICENSE
%doc %_pkgdocdir/readme.pdf
%doc %_pkgdocdir/reference.pdf

%files -n explain
%_bindir/explain
%_man1dir/*.1.*

%files devel
%_man3dir/*.3.*
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%dir %doc %_pkgdocdir
%doc %_pkgdocdir/building.pdf
%doc %_pkgdocdir/new_system_call.pdf

# NOTE rpmlint will complain about a use of mktemp.  This is because libexplain
# provides a wrapper for mktemp, not because it is used.

%changelog
