# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libfm-qt
Version: 1.4.0
Release: alt1

Summary: Core library of PCManFM-Qt file manager
License: LGPL-2.1
Group: System/Libraries

Url: https://github.com/lxqt/libfm-qt
Source: %name-%version.tar

BuildRequires: rpm-macros-cmake
BuildRequires: cmake
BuildRequires: rpm-build-xdg
BuildRequires: gcc-c++
BuildRequires: lxqt-build-tools >= 0.5.0
BuildRequires: libexif-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools-devel
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(libmenu-cache) >= 1.1.0
BuildRequires: lxqt-menu-data-devel

Requires: lxqt-menu-data >= 1.4.0

Obsoletes: libfm-qt3

%description
LibFM-Qt is a core library of PCManFM-Qt file manager.

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: libexif-devel libmenu-cache-devel
Requires: %name = %EVR

%description devel
This package contains files needed to build applications using LibFM-Qt.

%prep
%setup
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.hpp' -o -name '*.h' -print0 |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%cmake
export NPROCS=1
%cmake_build

%install
%cmake_install

# We need to fix this upstream
find %buildroot -size 0 -delete

%files
%_libdir/*.so.*
%_datadir/%name/
%_xdgmimedir/*/*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_datadir/cmake/fm-qt/*
%doc AUTHORS CHANGELOG LICENSE README.md

%changelog
