Name: libfreeimage
Version: 3.18.0
Release: alt7

Summary: Multi-format image decoder library
Group: System/Libraries
License: GPL and FIPL (see the license-fi.txt)
Url: http://freeimage.sourceforge.net/

%define srcversion %(echo %version | tr -d .)

Source: http://downloads.sourceforge.net/freeimage/FreeImage%srcversion.zip
# Unbundle bundled libraries (based on fc patch)
Patch: FreeImage_unbundle.patch
# Fix incorrect path in doxyfile
Patch1: FreeImage_doxygen.patch
# Fix incorrect variable names in BIGENDIAN blocks
Patch2: FreeImage_bigendian.patch
Patch3: FreeImage-3.18.0-alt-return-type.patch
Patch4: FreeImage-3.18-deb-libraw-0.20.patch
Patch5: libfreeimage-3.18.0-libtiff5.patch

BuildRequires: gcc-c++ libgomp-devel libmng-devel libpng-devel openexr-devel unzip
BuildPreReq: rpm-macros-make libraw-devel zlib-devel libwebp-devel
BuildPreReq: libtiff-devel libopenjpeg2.0-devel libjxr-devel
BuildRequires: dos2unix

%define nameplus %{name}plus

%description
FreeImage is a library project for developers who would like to support
popular graphics image formats like PNG, BMP, JPEG, TIFF and others as needed by
multimedia applications. FreeImage is easy to use, fast, multithreading, safe.

%package -n %nameplus
Summary: FreeImagePlus is a C++ wrapper for FreeImage
Group: System/Libraries
Requires: %name = %version-%release

%description -n %nameplus
The %nameplus package contains C++ wrapper library for %name.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files
for developing applications that use %name.

%package -n %nameplus-devel
Summary: Development files for %nameplus
Group: Development/C++
Requires: %nameplus = %version-%release

%description -n %nameplus-devel
The %nameplus-devel package contains libraries and header files
for developing C++ applications that use %nameplus.

%prep
%setup -n FreeImage
# fix line endings
find ./ -type f -print0| xargs -r0 dos2unix --

%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p2
%patch4 -p1
%patch5 -p2

# remove bundled libraries
rm -r Source/Lib* Source/ZLib Source/OpenEXR
# fix Makefile
sed -i 's|\-o root -g root ||g' Makefile.*
# we can't built due to dependencies on private headers
# see syslibs patch
> Source/FreeImage/PluginG3.cpp
> Source/FreeImageToolkit/JPEGTransform.cpp

%build
sh ./gensrclist.sh
sh ./genfipsrclist.sh
%add_optflags %optflags_shared -fvisibility=hidden
%make_build -f Makefile.gnu
%make_build -f Makefile.fip

%install
%makeinstall_std INSTALLDIR=%buildroot%_libdir
%makeinstall_std INSTALLDIR=%buildroot%_libdir -f Makefile.fip

%files
%_libdir/%name.so.*
%_libdir/%name-%version.so
%doc license-fi.txt Whatsnew.txt README.linux

%files -n %nameplus
%_libdir/%nameplus.so.*
%_libdir/%nameplus-%version.so

%exclude %_libdir/*.a

%files devel
%_includedir/*
%_libdir/libfreeimage.so

%files -n %nameplus-devel
%_libdir/%nameplus.so

%changelog
