%define _name garcon

%def_without builtin_menu
%def_enable introspection

Name: lib%_name
Version: 4.18.2
Release: alt1

Summary: Implementation of the freedesktop.org menu specification
License: LGPLv2+
Group: System/Libraries
URL: https://docs.xfce.org/xfce/garcon/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/garcon.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= 4.15.6-alt1 libxfce4ui-gtk3-devel >= 4.15.7-alt1
BuildRequires: glib2-devel >= 2.14
BuildRequires: libgtk+3-devel
BuildRequires: gtk-doc
BuildRequires: intltool
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxfce4util-gir-devel libxfce4ui-gtk3-gir-devel}

Obsoletes: libxfce4menu
Requires: xfce-freedesktop-menu
Requires: exo-utils

%define _unpackaged_files_terminate_build 1

%description
Garcon is an implementation of the freedesktop.org menu specification
replacing the former Xfce menu library libxfce4menu. It is based on
GLib/GIO only and aims at covering the entire specification except
for legacy menus.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains libraries and header files for
developing applications that use %name.

%if_enabled introspection
%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.
%endif

%package devel-doc
Summary: Development files for %name
License: GFDL-1.1+
Group: Development/C
Conflicts: %name-devel < %version
BuildArch: noarch

%description devel-doc
This package contains development documentation for %name.

%package gtk3
Summary: Common GTK+3 part of %name
Group: Graphical desktop/XFce
Requires: %name = %version-%release

%description gtk3
%summary

%package gtk3-devel
Summary: Development files for %name-gtk3
Group: Development/C
Requires: %name-gtk3 = %version-%release
Requires: %name-devel = %version-%release
Requires: libgtk+3-devel >= 2.12.0
Requires: libxfce4ui-gtk3-devel

%description gtk3-devel
%summary

%if_enabled introspection
%package gtk3-gir
Summary: GObject introspection data for %name-gtk3
Group: System/Libraries
Requires: %name-gtk3 = %EVR

%description gtk3-gir
GObject introspection data for %name-gtk3.

%package gtk3-gir-devel
Summary: GObject introspection devel data for %name-gtk3
Group: System/Libraries
BuildArch: noarch
Requires: %name-gtk3-gir = %EVR
Requires: %name-gtk3-devel = %EVR

%description gtk3-gir-devel
GObject introspection devel data for %name-gtk3.
%endif

%package freedesktop-menu
Summary: xfce menu shipped by default with %name
Group: Graphical desktop/XFce
Provides: xfce-freedesktop-menu
# because of %%_datadir/desktop-directories/xfce-*
Conflicts: xfdesktop <= 4.6.2
# to avoid conflicts during update
Requires: %name = %version-%release
BuildArch: noarch

%description freedesktop-menu
%summary

%package settings-manager-menu
Summary: Xfce menu directories for use with xfce4-settings.
Group: Graphical desktop/XFce
Requires: %name = %version-%release
BuildArch: noarch

%description settings-manager-menu
%summary

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
    --disable-static \
	%{subst_enable introspection} \
    --enable-gtk-doc \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std

# Remove uz@Latn: it is the same as uz and
# glibc not support such language in any case.
rm -rf %buildroot%_datadir/locale/uz@Latn/

%find_lang %_name

%files -f %_name.lang
%doc AUTHORS NEWS README.md
%_libdir/%name-1.so.*

%if_with builtin_menu
%files freedesktop-menu
%_datadir/desktop-directories/*
%config(noreplace) %_sysconfdir/xdg/menus/xfce-applications.menu
%else
%exclude %_datadir/desktop-directories/*
%exclude %_sysconfdir/xdg/menus/xfce-applications.menu
%endif

%files settings-manager-menu
%_datadir/desktop-directories/xfce-hardware.directory
%_datadir/desktop-directories/xfce-personal.directory
%_datadir/desktop-directories/xfce-other.directory
%_datadir/desktop-directories/xfce-system.directory

%files devel
%_includedir/%_name-1/
%_libdir/%name-1.so
%_libdir/pkgconfig/%_name-1.pc

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/Garcon-*.typelib

%files gir-devel
%_datadir/gir-1.0/Garcon-*.gir
%endif

%files devel-doc
%doc %_datadir/gtk-doc/html/%_name

%files gtk3
%_libdir/%name-gtk3-1.so.*
%_iconsdir/hicolor/*/*/*.*

%files gtk3-devel
%_includedir/%_name-gtk3-1/
%_libdir/%name-gtk3-1.so
%_libdir/pkgconfig/%_name-gtk3-1.pc

%if_enabled introspection
%files gtk3-gir
%_libdir/girepository-1.0/GarconGtk-*.typelib

%files gtk3-gir-devel
%_datadir/gir-1.0/GarconGtk-*.gir
%endif


%changelog
