%def_disable snapshot
%define ver_major 1.1
%define api_ver 1.0

%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable python
%def_enable ssh
%def_enable check

Name: libgit2-glib
Version: %ver_major.0
Release: alt1

Summary: Git library for GLib
Group: System/Libraries
License: LGPLv2+
Url: https://live.gnome.org/Libgit2-glib

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define libgit2_ver 0.25
%define glib_ver 2.44

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libgio-devel >= %glib_ver libgit2-devel >= %libgit2_ver
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools}
%{?_enable_python:BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel}
%{?_enable_ssh:BuildRequires: libssh2-devel}

%description
Libgit2-glib is a glib wrapper library around the libgit2 git access library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Libgit2-glib is a glib wrapper library around the libgit2 git access library.

The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the Libgit2-glib library
Group: System/Libraries
Requires: %name = %EVR

%description gir
Libgit2-glib is a glib wrapper library around the libgit2 git access library.

This package provides GObject introspection data for the Libgit2-glib library.

%package gir-devel
Summary: GObject introspection devel data for the Libgit2-glib library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
Libgit2-glib is a glib wrapper library around the libgit2 git access library.

This package provides GObject introspection devel data for the Libgit2-glib library .

%package devel-doc
Summary: Development documentation for Libgit2-glib
Group: Development/Documentation
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description devel-doc
Libgit2-glib is a glib wrapper library around the libgit2 git access library.

This package contains documentation needed for developing Libgit2-glib applications.


%prep
%setup
# fix python install dir
sed -i 's/purelib/platlib/' %name/meson.build

%build
%meson \
	%{?_enable_gtk_doc:-Dgtk_doc=true} \
	%{?_disable_introspection:-Dintrospection=false} \
	%{?_disable_vala:-Dvapi=false} \
	%{?_disable_python:-Dpython=false} \
	%{?_disable_ssh:-Dssh=false}
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_libdir/%name-%api_ver.so.*
%{?_enable_python:%python3_sitelibdir/gi/overrides/*}
%doc AUTHORS COPYING NEWS

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%if_enabled vala
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-%api_ver.deps
%_vapidir/ggit-%api_ver.vapi
%_vapidir/ggit-%api_ver.deps
%endif

%if_enabled introspection
%files gir
%_typelibdir/Ggit-%api_ver.typelib

%files gir-devel
%_girdir/Ggit-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
